/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Attributes;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.xds.LeastRequestLoadBalancerProvider;
import io.grpc.xds.ThreadSafeRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.seatunnel.shade.google.firestore.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.MoreObjects;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Objects;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;

final class LeastRequestLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final Attributes.Key<Ref<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create("state-info");
    @VisibleForTesting
    static final Attributes.Key<AtomicInteger> IN_FLIGHTS = Attributes.Key.create("in-flights");
    private final LoadBalancer.Helper helper;
    private final ThreadSafeRandom random;
    private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
    private ConnectivityState currentState;
    private LeastRequestPicker currentPicker = new EmptyPicker(EMPTY_OK);
    private int choiceCount = LeastRequestLoadBalancerProvider.DEFAULT_CHOICE_COUNT;
    private static final Status EMPTY_OK = Status.OK.withDescription("no subchannels ready");

    LeastRequestLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    LeastRequestLoadBalancer(LoadBalancer.Helper helper, ThreadSafeRandom random) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.random = Preconditions.checkNotNull(random, "random");
    }

    @Override
    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (resolvedAddresses.getAddresses().isEmpty()) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes()));
            return false;
        }
        LeastRequestConfig config = (LeastRequestConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (config != null) {
            this.choiceCount = config.choiceCount;
        }
        List<EquivalentAddressGroup> servers = resolvedAddresses.getAddresses();
        Set<EquivalentAddressGroup> currentAddrs = this.subchannels.keySet();
        Map<EquivalentAddressGroup, EquivalentAddressGroup> latestAddrs = LeastRequestLoadBalancer.stripAttrs(servers);
        Set<EquivalentAddressGroup> removedAddrs = LeastRequestLoadBalancer.setsDifference(currentAddrs, latestAddrs.keySet());
        for (Map.Entry<EquivalentAddressGroup, EquivalentAddressGroup> latestEntry : latestAddrs.entrySet()) {
            EquivalentAddressGroup strippedAddressGroup = latestEntry.getKey();
            EquivalentAddressGroup originalAddressGroup = latestEntry.getValue();
            LoadBalancer.Subchannel existingSubchannel = this.subchannels.get(strippedAddressGroup);
            if (existingSubchannel != null) {
                existingSubchannel.updateAddresses(Collections.singletonList(originalAddressGroup));
                continue;
            }
            Attributes.Builder subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new Ref<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE))).set(IN_FLIGHTS, new AtomicInteger(0));
            final LoadBalancer.Subchannel subchannel = Preconditions.checkNotNull(this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(originalAddressGroup).setAttributes(subchannelAttrs.build()).build()), "subchannel");
            subchannel.start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo state) {
                    LeastRequestLoadBalancer.this.processSubchannelState(subchannel, state);
                }
            });
            this.subchannels.put(strippedAddressGroup, subchannel);
            subchannel.requestConnection();
        }
        ArrayList<LoadBalancer.Subchannel> removedSubchannels = new ArrayList<LoadBalancer.Subchannel>();
        for (EquivalentAddressGroup addressGroup : removedAddrs) {
            removedSubchannels.add(this.subchannels.remove(addressGroup));
        }
        this.updateBalancingState();
        for (LoadBalancer.Subchannel removedSubchannel : removedSubchannels) {
            this.shutdownSubchannel(removedSubchannel);
        }
        return true;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.currentState != ConnectivityState.READY) {
            this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker(error));
        }
    }

    private void processSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        if (this.subchannels.get(LeastRequestLoadBalancer.stripAttrs(subchannel.getAddresses())) != subchannel) {
            return;
        }
        if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE || stateInfo.getState() == ConnectivityState.IDLE) {
            this.helper.refreshNameResolution();
        }
        if (stateInfo.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        Ref<ConnectivityStateInfo> subchannelStateRef = LeastRequestLoadBalancer.getSubchannelStateInfoRef(subchannel);
        if (((ConnectivityStateInfo)subchannelStateRef.value).getState().equals((Object)ConnectivityState.TRANSIENT_FAILURE) && (stateInfo.getState().equals((Object)ConnectivityState.CONNECTING) || stateInfo.getState().equals((Object)ConnectivityState.IDLE))) {
            return;
        }
        subchannelStateRef.value = stateInfo;
        this.updateBalancingState();
    }

    private void shutdownSubchannel(LoadBalancer.Subchannel subchannel) {
        subchannel.shutdown();
        LeastRequestLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value = ConnectivityStateInfo.forNonError(ConnectivityState.SHUTDOWN);
    }

    @Override
    public void shutdown() {
        for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
            this.shutdownSubchannel(subchannel);
        }
        this.subchannels.clear();
    }

    private void updateBalancingState() {
        List<LoadBalancer.Subchannel> activeList = LeastRequestLoadBalancer.filterNonFailingSubchannels(this.getSubchannels());
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            Status aggStatus = EMPTY_OK;
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)LeastRequestLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value;
                if (stateInfo.getState() == ConnectivityState.CONNECTING || stateInfo.getState() == ConnectivityState.IDLE) {
                    isConnecting = true;
                }
                if (aggStatus != EMPTY_OK && aggStatus.isOk()) continue;
                aggStatus = stateInfo.getStatus();
            }
            this.updateBalancingState(isConnecting ? ConnectivityState.CONNECTING : ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker(aggStatus));
        } else {
            this.updateBalancingState(ConnectivityState.READY, new ReadyPicker(activeList, this.choiceCount, this.random));
        }
    }

    private void updateBalancingState(ConnectivityState state, LeastRequestPicker picker) {
        if (state != this.currentState || !picker.isEquivalentTo(this.currentPicker)) {
            this.helper.updateBalancingState(state, picker);
            this.currentState = state;
            this.currentPicker = picker;
        }
    }

    private static List<LoadBalancer.Subchannel> filterNonFailingSubchannels(Collection<LoadBalancer.Subchannel> subchannels) {
        ArrayList<LoadBalancer.Subchannel> readySubchannels = new ArrayList<LoadBalancer.Subchannel>(subchannels.size());
        for (LoadBalancer.Subchannel subchannel : subchannels) {
            if (!LeastRequestLoadBalancer.isReady(subchannel)) continue;
            readySubchannels.add(subchannel);
        }
        return readySubchannels;
    }

    private static Map<EquivalentAddressGroup, EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> groupList) {
        HashMap<EquivalentAddressGroup, EquivalentAddressGroup> addrs = new HashMap<EquivalentAddressGroup, EquivalentAddressGroup>(groupList.size() * 2);
        for (EquivalentAddressGroup group : groupList) {
            addrs.put(LeastRequestLoadBalancer.stripAttrs(group), group);
        }
        return addrs;
    }

    private static EquivalentAddressGroup stripAttrs(EquivalentAddressGroup eag) {
        return new EquivalentAddressGroup(eag.getAddresses());
    }

    @VisibleForTesting
    Collection<LoadBalancer.Subchannel> getSubchannels() {
        return this.subchannels.values();
    }

    private static Ref<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer.Subchannel subchannel) {
        return Preconditions.checkNotNull(subchannel.getAttributes().get(STATE_INFO), "STATE_INFO");
    }

    private static AtomicInteger getInFlights(LoadBalancer.Subchannel subchannel) {
        return Preconditions.checkNotNull(subchannel.getAttributes().get(IN_FLIGHTS), "IN_FLIGHTS");
    }

    static boolean isReady(LoadBalancer.Subchannel subchannel) {
        return ((ConnectivityStateInfo)LeastRequestLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value).getState() == ConnectivityState.READY;
    }

    private static <T> Set<T> setsDifference(Set<T> a, Set<T> b) {
        HashSet<T> aCopy = new HashSet<T>(a);
        aCopy.removeAll(b);
        return aCopy;
    }

    static final class LeastRequestConfig {
        final int choiceCount;

        LeastRequestConfig(int choiceCount) {
            Preconditions.checkArgument(choiceCount >= 2, "choiceCount <= 1");
            this.choiceCount = Math.min(choiceCount, 10);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("choiceCount", this.choiceCount).toString();
        }
    }

    private static final class OutstandingRequestsTracingFactory
    extends ClientStreamTracer.Factory {
        private final AtomicInteger inFlights;

        private OutstandingRequestsTracingFactory(AtomicInteger inFlights) {
            this.inFlights = Preconditions.checkNotNull(inFlights, "inFlights");
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            return new ClientStreamTracer(){

                @Override
                public void streamCreated(Attributes transportAttrs, Metadata headers) {
                    inFlights.incrementAndGet();
                }

                @Override
                public void streamClosed(Status status) {
                    inFlights.decrementAndGet();
                }
            };
        }
    }

    static final class Ref<T> {
        T value;

        Ref(T value) {
            this.value = value;
        }
    }

    @VisibleForTesting
    static final class EmptyPicker
    extends LeastRequestPicker {
        private final Status status;

        EmptyPicker(@Nonnull Status status) {
            this.status = Preconditions.checkNotNull(status, "status");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args2) {
            return this.status.isOk() ? LoadBalancer.PickResult.withNoResult() : LoadBalancer.PickResult.withError(this.status);
        }

        @Override
        boolean isEquivalentTo(LeastRequestPicker picker) {
            return picker instanceof EmptyPicker && (Objects.equal(this.status, ((EmptyPicker)picker).status) || this.status.isOk() && ((EmptyPicker)picker).status.isOk());
        }

        public String toString() {
            return MoreObjects.toStringHelper(EmptyPicker.class).add("status", this.status).toString();
        }
    }

    @VisibleForTesting
    static final class ReadyPicker
    extends LeastRequestPicker {
        private final List<LoadBalancer.Subchannel> list;
        private final int choiceCount;
        private final ThreadSafeRandom random;

        ReadyPicker(List<LoadBalancer.Subchannel> list, int choiceCount, ThreadSafeRandom random) {
            Preconditions.checkArgument(!list.isEmpty(), "empty list");
            this.list = list;
            this.choiceCount = choiceCount;
            this.random = Preconditions.checkNotNull(random, "random");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args2) {
            LoadBalancer.Subchannel subchannel = this.nextSubchannel();
            OutstandingRequestsTracingFactory factory = new OutstandingRequestsTracingFactory(LeastRequestLoadBalancer.getInFlights(subchannel));
            return LoadBalancer.PickResult.withSubchannel(subchannel, factory);
        }

        public String toString() {
            return MoreObjects.toStringHelper(ReadyPicker.class).add("list", this.list).add("choiceCount", this.choiceCount).toString();
        }

        private LoadBalancer.Subchannel nextSubchannel() {
            LoadBalancer.Subchannel candidate = this.list.get(this.random.nextInt(this.list.size()));
            for (int i = 0; i < this.choiceCount - 1; ++i) {
                LoadBalancer.Subchannel sampled = this.list.get(this.random.nextInt(this.list.size()));
                if (LeastRequestLoadBalancer.getInFlights(sampled).get() >= LeastRequestLoadBalancer.getInFlights(candidate).get()) continue;
                candidate = sampled;
            }
            return candidate;
        }

        @VisibleForTesting
        List<LoadBalancer.Subchannel> getList() {
            return this.list;
        }

        @Override
        boolean isEquivalentTo(LeastRequestPicker picker) {
            if (!(picker instanceof ReadyPicker)) {
                return false;
            }
            ReadyPicker other = (ReadyPicker)picker;
            return other == this || this.list.size() == other.list.size() && new HashSet<LoadBalancer.Subchannel>(this.list).containsAll(other.list) && this.choiceCount == other.choiceCount;
        }
    }

    private static abstract class LeastRequestPicker
    extends LoadBalancer.SubchannelPicker {
        private LeastRequestPicker() {
        }

        abstract boolean isEquivalentTo(LeastRequestPicker var1);
    }
}

