/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.xds.FaultFilter;
import io.grpc.xds.Filter;
import io.grpc.xds.RbacFilter;
import io.grpc.xds.RouterFilter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.annotations.VisibleForTesting;

final class FilterRegistry {
    private static FilterRegistry instance;
    private final Map<String, Filter> supportedFilters = new HashMap<String, Filter>();

    private FilterRegistry() {
    }

    static synchronized FilterRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = FilterRegistry.newRegistry().register(FaultFilter.INSTANCE, RouterFilter.INSTANCE, RbacFilter.INSTANCE);
        }
        return instance;
    }

    @VisibleForTesting
    static FilterRegistry newRegistry() {
        return new FilterRegistry();
    }

    @VisibleForTesting
    FilterRegistry register(Filter ... filters) {
        for (Filter filter : filters) {
            for (String typeUrl : filter.typeUrls()) {
                this.supportedFilters.put(typeUrl, filter);
            }
        }
        return this;
    }

    @Nullable
    Filter get(String typeUrl) {
        return this.supportedFilters.get(typeUrl);
    }
}

