/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.ClusterImplLoadBalancer;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.MoreObjects;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;

@Internal
public final class ClusterImplLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "cluster_impl_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        throw new UnsupportedOperationException("not supported as top-level LB policy");
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterImplLoadBalancer(helper);
    }

    static final class ClusterImplConfig {
        final String cluster;
        @Nullable
        final String edsServiceName;
        @Nullable
        final Bootstrapper.ServerInfo lrsServerInfo;
        @Nullable
        final Long maxConcurrentRequests;
        @Nullable
        final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
        final List<Endpoints.DropOverload> dropCategories;
        final ServiceConfigUtil.PolicySelection childPolicy;

        ClusterImplConfig(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, List<Endpoints.DropOverload> dropCategories, ServiceConfigUtil.PolicySelection childPolicy, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
            this.cluster = Preconditions.checkNotNull(cluster, "cluster");
            this.edsServiceName = edsServiceName;
            this.lrsServerInfo = lrsServerInfo;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.tlsContext = tlsContext;
            this.dropCategories = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(dropCategories, "dropCategories")));
            this.childPolicy = Preconditions.checkNotNull(childPolicy, "childPolicy");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("cluster", this.cluster).add("edsServiceName", this.edsServiceName).add("lrsServerInfo", this.lrsServerInfo).add("maxConcurrentRequests", this.maxConcurrentRequests).add("dropCategories", this.dropCategories).add("childPolicy", this.childPolicy).toString();
        }
    }
}

