/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.services.internal;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.protobuf.services.HealthCheckingLoadBalancerUtil;
import java.util.Map;
import org.apache.seatunnel.shade.google.firestore.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Throwables;

@Internal
public final class HealthCheckingRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    private final LoadBalancerProvider rrProvider = HealthCheckingRoundRobinLoadBalancerProvider.newRoundRobinProvider();

    @Override
    public boolean isAvailable() {
        return this.rrProvider.isAvailable();
    }

    @Override
    public int getPriority() {
        return this.rrProvider.getPriority() + 1;
    }

    @Override
    public String getPolicyName() {
        return this.rrProvider.getPolicyName();
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return HealthCheckingLoadBalancerUtil.newHealthCheckingLoadBalancer(this.rrProvider, helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return this.rrProvider.parseLoadBalancingPolicyConfig(rawLoadBalancingPolicyConfig);
    }

    @VisibleForTesting
    static LoadBalancerProvider newRoundRobinProvider() {
        try {
            Class<LoadBalancerProvider> rrProviderClass = Class.forName("io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider").asSubclass(LoadBalancerProvider.class);
            return rrProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

