/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.TimeProvider;
import io.grpc.lb.v1.ClientStats;
import io.grpc.lb.v1.ClientStatsPerToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.util.Timestamps;

@ThreadSafe
final class GrpclbClientLoadRecorder
extends ClientStreamTracer.Factory {
    private static final AtomicLongFieldUpdater<GrpclbClientLoadRecorder> callsStartedUpdater = AtomicLongFieldUpdater.newUpdater(GrpclbClientLoadRecorder.class, "callsStarted");
    private static final AtomicLongFieldUpdater<GrpclbClientLoadRecorder> callsFinishedUpdater = AtomicLongFieldUpdater.newUpdater(GrpclbClientLoadRecorder.class, "callsFinished");
    private static final AtomicLongFieldUpdater<GrpclbClientLoadRecorder> callsFailedToSendUpdater = AtomicLongFieldUpdater.newUpdater(GrpclbClientLoadRecorder.class, "callsFailedToSend");
    private static final AtomicLongFieldUpdater<GrpclbClientLoadRecorder> callsFinishedKnownReceivedUpdater = AtomicLongFieldUpdater.newUpdater(GrpclbClientLoadRecorder.class, "callsFinishedKnownReceived");
    private final TimeProvider time;
    private volatile long callsStarted;
    private volatile long callsFinished;
    @GuardedBy(value="this")
    private Map<String, LongHolder> callsDroppedPerToken = new HashMap<String, LongHolder>(1);
    private volatile long callsFailedToSend;
    private volatile long callsFinishedKnownReceived;

    GrpclbClientLoadRecorder(TimeProvider time) {
        this.time = Preconditions.checkNotNull(time, "time provider");
    }

    @Override
    public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
        callsStartedUpdater.getAndIncrement(this);
        return new StreamTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordDroppedRequest(String token) {
        callsStartedUpdater.getAndIncrement(this);
        callsFinishedUpdater.getAndIncrement(this);
        GrpclbClientLoadRecorder grpclbClientLoadRecorder = this;
        synchronized (grpclbClientLoadRecorder) {
            LongHolder holder = this.callsDroppedPerToken.get(token);
            if (holder == null) {
                holder = new LongHolder();
                this.callsDroppedPerToken.put(token, holder);
            }
            ++holder.num;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientStats generateLoadReport() {
        ClientStats.Builder statsBuilder = ClientStats.newBuilder().setTimestamp(Timestamps.fromNanos(this.time.currentTimeNanos())).setNumCallsStarted(callsStartedUpdater.getAndSet(this, 0L)).setNumCallsFinished(callsFinishedUpdater.getAndSet(this, 0L)).setNumCallsFinishedWithClientFailedToSend(callsFailedToSendUpdater.getAndSet(this, 0L)).setNumCallsFinishedKnownReceived(callsFinishedKnownReceivedUpdater.getAndSet(this, 0L));
        Map<Object, Object> localCallsDroppedPerToken = Collections.emptyMap();
        GrpclbClientLoadRecorder grpclbClientLoadRecorder = this;
        synchronized (grpclbClientLoadRecorder) {
            if (!this.callsDroppedPerToken.isEmpty()) {
                localCallsDroppedPerToken = this.callsDroppedPerToken;
                this.callsDroppedPerToken = new HashMap<String, LongHolder>(localCallsDroppedPerToken.size());
            }
        }
        for (Map.Entry entry : localCallsDroppedPerToken.entrySet()) {
            statsBuilder.addCallsFinishedWithDrop(ClientStatsPerToken.newBuilder().setLoadBalanceToken((String)entry.getKey()).setNumCalls(((LongHolder)entry.getValue()).num).build());
        }
        return statsBuilder.build();
    }

    private class StreamTracer
    extends ClientStreamTracer {
        private volatile boolean headersSent;
        private volatile boolean anythingReceived;

        private StreamTracer() {
        }

        @Override
        public void outboundHeaders() {
            this.headersSent = true;
        }

        @Override
        public void inboundHeaders() {
            this.anythingReceived = true;
        }

        @Override
        public void inboundMessage(int seqNo) {
            this.anythingReceived = true;
        }

        @Override
        public void streamClosed(Status status) {
            callsFinishedUpdater.getAndIncrement(GrpclbClientLoadRecorder.this);
            if (!this.headersSent) {
                callsFailedToSendUpdater.getAndIncrement(GrpclbClientLoadRecorder.this);
            }
            if (this.anythingReceived) {
                callsFinishedKnownReceivedUpdater.getAndIncrement(GrpclbClientLoadRecorder.this);
            }
        }
    }

    private static final class LongHolder {
        long num;

        private LongHolder() {
        }
    }
}

