/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.oauth2.ComputeEngineCredentials;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.CompositeChannelCredentials;
import io.grpc.Status;
import io.grpc.alts.FailingCallCredentials;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.InternalCheckGcpEnvironment;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLException;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableList;

public final class ComputeEngineChannelCredentials {
    private ComputeEngineChannelCredentials() {
    }

    public static ChannelCredentials create() {
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(ComputeEngineChannelCredentials.createClientFactory());
        CallCredentials callCredentials = InternalCheckGcpEnvironment.isOnGcp() ? MoreCallCredentials.from(ComputeEngineCredentials.create()) : new FailingCallCredentials(Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform"));
        return CompositeChannelCredentials.create(nettyCredentials, callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

