/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableMap;

public class DocumentPathName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/databases/{database}/documents/{document_path=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String documentPath;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDocumentPath() {
        return this.documentPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DocumentPathName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.database = Preconditions.checkNotNull(builder.getDatabase());
        this.documentPath = Preconditions.checkNotNull(builder.getDocumentPath());
    }

    public static DocumentPathName of(String project, String database, String documentPath) {
        return DocumentPathName.newBuilder().setProject(project).setDatabase(database).setDocumentPath(documentPath).build();
    }

    public static String format(String project, String database, String documentPath) {
        return DocumentPathName.newBuilder().setProject(project).setDatabase(database).setDocumentPath(documentPath).build().toString();
    }

    public static DocumentPathName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DocumentPathName.parse: formattedString not in valid format");
        return DocumentPathName.of(matchMap.get("project"), matchMap.get("database"), matchMap.get("document_path"));
    }

    public static List<DocumentPathName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentPathName> list = new ArrayList<DocumentPathName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentPathName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentPathName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentPathName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentPathName documentPathName = this;
            synchronized (documentPathName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("database", this.database);
                    fieldMapBuilder.put("documentPath", this.documentPath);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "database", this.database, "document_path", this.documentPath);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DocumentPathName) {
            DocumentPathName that = (DocumentPathName)o;
            return this.project.equals(that.project) && this.database.equals(that.database) && this.documentPath.equals(that.documentPath);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.project.hashCode();
        h2 *= 1000003;
        h2 ^= this.database.hashCode();
        h2 *= 1000003;
        return h2 ^= this.documentPath.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;
        private String documentPath;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getDocumentPath() {
            return this.documentPath;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setDocumentPath(String documentPath) {
            this.documentPath = documentPath;
            return this;
        }

        private Builder() {
        }

        private Builder(DocumentPathName documentPathName) {
            this.project = documentPathName.project;
            this.database = documentPathName.database;
            this.documentPath = documentPathName.documentPath;
        }

        public DocumentPathName build() {
            return new DocumentPathName(this);
        }
    }
}

