/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableMap;

public class DatabaseRootName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/databases/{database}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DatabaseRootName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.database = Preconditions.checkNotNull(builder.getDatabase());
    }

    public static DatabaseRootName of(String project, String database) {
        return DatabaseRootName.newBuilder().setProject(project).setDatabase(database).build();
    }

    public static String format(String project, String database) {
        return DatabaseRootName.newBuilder().setProject(project).setDatabase(database).build().toString();
    }

    public static DatabaseRootName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DatabaseRootName.parse: formattedString not in valid format");
        return DatabaseRootName.of(matchMap.get("project"), matchMap.get("database"));
    }

    public static List<DatabaseRootName> parseList(List<String> formattedStrings) {
        ArrayList<DatabaseRootName> list = new ArrayList<DatabaseRootName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatabaseRootName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatabaseRootName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatabaseRootName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatabaseRootName databaseRootName = this;
            synchronized (databaseRootName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("database", this.database);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "database", this.database);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatabaseRootName) {
            DatabaseRootName that = (DatabaseRootName)o;
            return this.project.equals(that.project) && this.database.equals(that.database);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.project.hashCode();
        h2 *= 1000003;
        return h2 ^= this.database.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        private Builder() {
        }

        private Builder(DatabaseRootName databaseRootName) {
            this.project = databaseRootName.project;
            this.database = databaseRootName.database;
        }

        public DatabaseRootName build() {
            return new DatabaseRootName(this);
        }
    }
}

