/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.FirestoreStubSettings;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreCallableFactory;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableMap;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.Empty;

public class GrpcFirestoreStub
extends FirestoreStub {
    private static final MethodDescriptor<GetDocumentRequest, Document> getDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/GetDocument").setRequestMarshaller(ProtoUtils.marshaller(GetDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Document.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDocumentsRequest, ListDocumentsResponse> listDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/ListDocuments").setRequestMarshaller(ProtoUtils.marshaller(ListDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDocumentRequest, Document> updateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/UpdateDocument").setRequestMarshaller(ProtoUtils.marshaller(UpdateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Document.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDocumentRequest, Empty> deleteDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/DeleteDocument").setRequestMarshaller(ProtoUtils.marshaller(DeleteDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.firestore.v1.Firestore/BatchGetDocuments").setRequestMarshaller(ProtoUtils.marshaller(BatchGetDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(BatchGetDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BeginTransactionRequest, BeginTransactionResponse> beginTransactionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/BeginTransaction").setRequestMarshaller(ProtoUtils.marshaller(BeginTransactionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(BeginTransactionResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CommitRequest, CommitResponse> commitMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/Commit").setRequestMarshaller(ProtoUtils.marshaller(CommitRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(CommitResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RollbackRequest, Empty> rollbackMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/Rollback").setRequestMarshaller(ProtoUtils.marshaller(RollbackRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<RunQueryRequest, RunQueryResponse> runQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.firestore.v1.Firestore/RunQuery").setRequestMarshaller(ProtoUtils.marshaller(RunQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(RunQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.firestore.v1.Firestore/RunAggregationQuery").setRequestMarshaller(ProtoUtils.marshaller(RunAggregationQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(RunAggregationQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PartitionQueryRequest, PartitionQueryResponse> partitionQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/PartitionQuery").setRequestMarshaller(ProtoUtils.marshaller(PartitionQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(PartitionQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<WriteRequest, WriteResponse> writeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.firestore.v1.Firestore/Write").setRequestMarshaller(ProtoUtils.marshaller(WriteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(WriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListenRequest, ListenResponse> listenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.firestore.v1.Firestore/Listen").setRequestMarshaller(ProtoUtils.marshaller(ListenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListenResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/ListCollectionIds").setRequestMarshaller(ProtoUtils.marshaller(ListCollectionIdsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListCollectionIdsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchWriteRequest, BatchWriteResponse> batchWriteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/BatchWrite").setRequestMarshaller(ProtoUtils.marshaller(BatchWriteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(BatchWriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateDocumentRequest, Document> createDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.firestore.v1.Firestore/CreateDocument").setRequestMarshaller(ProtoUtils.marshaller(CreateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Document.getDefaultInstance())).build();
    private final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable;
    private final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable;
    private final UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> listDocumentsPagedCallable;
    private final UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable;
    private final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable;
    private final ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable;
    private final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable;
    private final UnaryCallable<CommitRequest, CommitResponse> commitCallable;
    private final UnaryCallable<RollbackRequest, Empty> rollbackCallable;
    private final ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable;
    private final ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable;
    private final UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> partitionQueryCallable;
    private final UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> partitionQueryPagedCallable;
    private final BidiStreamingCallable<WriteRequest, WriteResponse> writeCallable;
    private final BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable;
    private final UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable;
    private final UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable;
    private final UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable;
    private final UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFirestoreStub create(FirestoreStubSettings settings) throws IOException {
        return new GrpcFirestoreStub(settings, ClientContext.create(settings));
    }

    public static final GrpcFirestoreStub create(ClientContext clientContext) throws IOException {
        return new GrpcFirestoreStub(FirestoreStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFirestoreStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFirestoreStub(FirestoreStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFirestoreStub(FirestoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFirestoreCallableFactory());
    }

    protected GrpcFirestoreStub(FirestoreStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<GetDocumentRequest, Document> getDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("name", String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings<ListDocumentsRequest, ListDocumentsResponse> listDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("collection_id", String.valueOf(request.getCollectionId()));
            params.put("parent", String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings<UpdateDocumentRequest, Document> updateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("document.name", String.valueOf(request.getDocument().getName()));
            return params.build();
        }).build();
        GrpcCallSettings<DeleteDocumentRequest, Empty> deleteDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("name", String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchGetDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("database", String.valueOf(request.getDatabase()));
            return params.build();
        }).build();
        GrpcCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(beginTransactionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("database", String.valueOf(request.getDatabase()));
            return params.build();
        }).build();
        GrpcCallSettings<CommitRequest, CommitResponse> commitTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(commitMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("database", String.valueOf(request.getDatabase()));
            return params.build();
        }).build();
        GrpcCallSettings<RollbackRequest, Empty> rollbackTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rollbackMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("database", String.valueOf(request.getDatabase()));
            return params.build();
        }).build();
        GrpcCallSettings<RunQueryRequest, RunQueryResponse> runQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runQueryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("parent", String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runAggregationQueryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("parent", String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings<PartitionQueryRequest, PartitionQueryResponse> partitionQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(partitionQueryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("parent", String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings<WriteRequest, WriteResponse> writeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(writeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("database", String.valueOf(request.getDatabase()));
            return params.build();
        }).build();
        GrpcCallSettings<ListenRequest, ListenResponse> listenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listenMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("database", String.valueOf(request.getDatabase()));
            return params.build();
        }).build();
        GrpcCallSettings<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCollectionIdsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("parent", String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings<BatchWriteRequest, BatchWriteResponse> batchWriteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchWriteMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("database", String.valueOf(request.getDatabase()));
            return params.build();
        }).build();
        GrpcCallSettings<CreateDocumentRequest, Document> createDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("collection_id", String.valueOf(request.getCollectionId()));
            params.put("parent", String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.listDocumentsCallable = callableFactory.createUnaryCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.listDocumentsPagedCallable = callableFactory.createPagedCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.updateDocumentCallable = callableFactory.createUnaryCallable(updateDocumentTransportSettings, settings.updateDocumentSettings(), clientContext);
        this.deleteDocumentCallable = callableFactory.createUnaryCallable(deleteDocumentTransportSettings, settings.deleteDocumentSettings(), clientContext);
        this.batchGetDocumentsCallable = callableFactory.createServerStreamingCallable(batchGetDocumentsTransportSettings, settings.batchGetDocumentsSettings(), clientContext);
        this.beginTransactionCallable = callableFactory.createUnaryCallable(beginTransactionTransportSettings, settings.beginTransactionSettings(), clientContext);
        this.commitCallable = callableFactory.createUnaryCallable(commitTransportSettings, settings.commitSettings(), clientContext);
        this.rollbackCallable = callableFactory.createUnaryCallable(rollbackTransportSettings, settings.rollbackSettings(), clientContext);
        this.runQueryCallable = callableFactory.createServerStreamingCallable(runQueryTransportSettings, settings.runQuerySettings(), clientContext);
        this.runAggregationQueryCallable = callableFactory.createServerStreamingCallable(runAggregationQueryTransportSettings, settings.runAggregationQuerySettings(), clientContext);
        this.partitionQueryCallable = callableFactory.createUnaryCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.partitionQueryPagedCallable = callableFactory.createPagedCallable(partitionQueryTransportSettings, settings.partitionQuerySettings(), clientContext);
        this.writeCallable = callableFactory.createBidiStreamingCallable(writeTransportSettings, settings.writeSettings(), clientContext);
        this.listenCallable = callableFactory.createBidiStreamingCallable(listenTransportSettings, settings.listenSettings(), clientContext);
        this.listCollectionIdsCallable = callableFactory.createUnaryCallable(listCollectionIdsTransportSettings, settings.listCollectionIdsSettings(), clientContext);
        this.listCollectionIdsPagedCallable = callableFactory.createPagedCallable(listCollectionIdsTransportSettings, settings.listCollectionIdsSettings(), clientContext);
        this.batchWriteCallable = callableFactory.createUnaryCallable(batchWriteTransportSettings, settings.batchWriteSettings(), clientContext);
        this.createDocumentCallable = callableFactory.createUnaryCallable(createDocumentTransportSettings, settings.createDocumentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.listDocumentsCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.listDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable() {
        return this.updateDocumentCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.deleteDocumentCallable;
    }

    @Override
    public ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable() {
        return this.batchGetDocumentsCallable;
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.beginTransactionCallable;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.commitCallable;
    }

    @Override
    public UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.rollbackCallable;
    }

    @Override
    public ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.runQueryCallable;
    }

    @Override
    public ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.runAggregationQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> partitionQueryCallable() {
        return this.partitionQueryCallable;
    }

    @Override
    public UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> partitionQueryPagedCallable() {
        return this.partitionQueryPagedCallable;
    }

    @Override
    public BidiStreamingCallable<WriteRequest, WriteResponse> writeCallable() {
        return this.writeCallable;
    }

    @Override
    public BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable() {
        return this.listenCallable;
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable() {
        return this.listCollectionIdsCallable;
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable() {
        return this.listCollectionIdsPagedCallable;
    }

    @Override
    public UnaryCallable<BatchWriteRequest, BatchWriteResponse> batchWriteCallable() {
        return this.batchWriteCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable() {
        return this.createDocumentCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

