/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.TraceUtil;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.ListDocumentsRequest;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.util.concurrent.MoreExecutors;

@InternalExtensionOnly
public class CollectionReference
extends Query {
    CollectionReference(FirestoreRpcContext<?> rpcContext, ResourcePath collectionPath) {
        super(rpcContext, collectionPath);
    }

    @Nonnull
    public String getId() {
        return this.options.getCollectionId();
    }

    @Nullable
    public DocumentReference getParent() {
        ResourcePath parent = this.options.getParentPath();
        return parent.isDocument() ? new DocumentReference(this.rpcContext, parent) : null;
    }

    @Nonnull
    public String getPath() {
        return this.getResourcePath().getPath();
    }

    @Nonnull
    public DocumentReference document() {
        return this.document(FirestoreImpl.autoId());
    }

    @Nonnull
    public DocumentReference document(@Nonnull String childPath) {
        ResourcePath documentPath = (ResourcePath)this.getResourcePath().append(childPath);
        Preconditions.checkArgument(documentPath.isDocument(), String.format("Path should point to a Document Reference: %s", this.getPath()));
        return new DocumentReference(this.rpcContext, documentPath);
    }

    @Nonnull
    public Iterable<DocumentReference> listDocuments() {
        FirestoreClient.ListDocumentsPagedResponse response;
        ListDocumentsRequest.Builder request = ListDocumentsRequest.newBuilder();
        request.setParent(this.options.getParentPath().toString());
        request.setCollectionId(this.options.getCollectionId());
        request.setMask(DocumentMask.getDefaultInstance());
        request.setShowMissing(true);
        TraceUtil traceUtil = TraceUtil.getInstance();
        Span span = traceUtil.startSpan("CloudFirestoreOperation.ListDocuments");
        try (Scope scope = traceUtil.getTracer().withSpan(span);){
            FirestoreRpc client = this.rpcContext.getClient();
            UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> callable = client.listDocumentsPagedCallable();
            ListDocumentsRequest build = request.build();
            ApiFuture<FirestoreClient.ListDocumentsPagedResponse> future = this.rpcContext.sendRequest(build, callable);
            response = ApiExceptions.callAndTranslateApiException(future);
        }
        catch (ApiException exception) {
            span.setStatus(Status.UNKNOWN.withDescription(exception.getMessage()));
            throw FirestoreException.forApiException(exception);
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
        return new Iterable<DocumentReference>(){

            @Override
            @Nonnull
            public Iterator<DocumentReference> iterator() {
                final Iterator iterator2 = response.iterateAll().iterator();
                return new Iterator<DocumentReference>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public DocumentReference next() {
                        ResourcePath path = ResourcePath.create(((Document)iterator2.next()).getName());
                        return CollectionReference.this.document(path.getId());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    @Nonnull
    public ApiFuture<DocumentReference> add(@Nonnull Map<String, Object> fields) {
        DocumentReference documentReference = this.document();
        ApiFuture<WriteResult> createFuture = documentReference.create(fields);
        return ApiFutures.transform(createFuture, writeResult -> documentReference, MoreExecutors.directExecutor());
    }

    public ApiFuture<DocumentReference> add(Object pojo) {
        Object converted = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(converted instanceof Map)) {
            throw FirestoreException.forInvalidArgument("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.add((Map)converted);
    }

    ResourcePath getResourcePath() {
        return (ResourcePath)this.options.getParentPath().append(this.options.getCollectionId());
    }
}

