/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterOperation;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.WriteResult;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.rpc.Status;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableMap;
import org.apache.seatunnel.shade.google.firestore.com.google.common.util.concurrent.MoreExecutors;

class BulkCommitBatch
extends UpdateBuilder<ApiFuture<WriteResult>> {
    final List<BulkWriterOperation> pendingOperations = new ArrayList<BulkWriterOperation>();
    private final Set<DocumentReference> documents = new CopyOnWriteArraySet<DocumentReference>();
    private final Executor executor;
    private int maxBatchSize;

    BulkCommitBatch(FirestoreImpl firestore, Executor executor, int maxBatchSize) {
        super(firestore);
        this.executor = executor;
        this.maxBatchSize = maxBatchSize;
    }

    int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    void setMaxBatchSize(int size) {
        Preconditions.checkState(this.getMutationsSize() <= size, "New batch size cannot be less than the number of enqueued writes");
        this.maxBatchSize = size;
    }

    @Override
    ApiFuture<WriteResult> wrapResult(int writeIndex) {
        return this.pendingOperations.get(writeIndex).getFuture();
    }

    ApiFuture<Void> bulkCommit() {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.BatchWrite", ImmutableMap.of("numDocuments", AttributeValue.longAttributeValue(this.getWrites().size())));
        BatchWriteRequest.Builder request = BatchWriteRequest.newBuilder();
        request.setDatabase(this.firestore.getDatabaseName());
        for (UpdateBuilder.WriteOperation writeOperation : this.getWrites()) {
            request.addWrites(writeOperation.write);
        }
        this.committed = true;
        ApiFuture<BatchWriteResponse> response = this.processExceptions(this.firestore.sendRequest(request.build(), this.firestore.getClient().batchWriteCallable()));
        return ApiFutures.transformAsync(response, batchWriteResponse -> {
            ArrayList<ApiFuture<Void>> pendingUserCallbacks = new ArrayList<ApiFuture<Void>>();
            List<com.google.firestore.v1.WriteResult> writeResults = batchWriteResponse.getWriteResultsList();
            List<Status> statuses = batchWriteResponse.getStatusList();
            for (int i = 0; i < writeResults.size(); ++i) {
                com.google.firestore.v1.WriteResult writeResult = writeResults.get(i);
                Status status = statuses.get(i);
                BulkWriterOperation operation = this.pendingOperations.get(i);
                io.grpc.Status code = io.grpc.Status.fromCodeValue(status.getCode());
                if (code == io.grpc.Status.OK) {
                    pendingUserCallbacks.add(operation.onSuccess(new WriteResult(Timestamp.fromProto(writeResult.getUpdateTime()))));
                    continue;
                }
                pendingUserCallbacks.add(operation.onException(FirestoreException.forServerRejection(code, status.getMessage(), new Object[0])));
            }
            return BulkWriter.silenceFuture(ApiFutures.allAsList(pendingUserCallbacks));
        }, this.executor);
    }

    private ApiFuture<BatchWriteResponse> processExceptions(ApiFuture<BatchWriteResponse> response) {
        return ApiFutures.catching(response, ApiException.class, exception -> {
            Status.Builder status = Status.newBuilder().setCode(exception.getStatusCode().getCode().ordinal()).setMessage(exception.getMessage());
            BatchWriteResponse.Builder responseBuilder = BatchWriteResponse.newBuilder();
            for (int i = 0; i < this.pendingOperations.size(); ++i) {
                responseBuilder.addWriteResults(com.google.firestore.v1.WriteResult.getDefaultInstance());
                responseBuilder.addStatus(status);
            }
            return responseBuilder.build();
        }, MoreExecutors.directExecutor());
    }

    void enqueueOperation(BulkWriterOperation operation) {
        boolean added = this.documents.add(operation.getDocumentReference());
        Preconditions.checkState(added, "Batch should not contain writes to the same document");
        this.pendingOperations.add(operation);
    }

    boolean has(DocumentReference documentReference) {
        return this.documents.contains(documentReference);
    }
}

