/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredAggregationQuery;
import com.google.firestore.v1.Value;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.ByteString;

@InternalExtensionOnly
public class AggregateQuery {
    private static final String ALIAS_COUNT = "count";
    @Nonnull
    private final Query query;

    AggregateQuery(@Nonnull Query query) {
        this.query = query;
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public ApiFuture<AggregateQuerySnapshot> get() {
        return this.get(null);
    }

    @Nonnull
    ApiFuture<AggregateQuerySnapshot> get(@Nullable ByteString transactionId) {
        AggregateQueryResponseDeliverer responseDeliverer = new AggregateQueryResponseDeliverer(transactionId, this.query.rpcContext.getClock().nanoTime());
        this.runQuery(responseDeliverer);
        return responseDeliverer.getFuture();
    }

    private void runQuery(AggregateQueryResponseDeliverer responseDeliverer) {
        RunAggregationQueryRequest request = this.toProto(responseDeliverer.getTransactionId());
        AggregateQueryResponseObserver responseObserver = new AggregateQueryResponseObserver(responseDeliverer);
        ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> callable = this.query.rpcContext.getClient().runAggregationQueryCallable();
        this.query.rpcContext.streamRequest(request, responseObserver, callable);
    }

    @Nonnull
    public RunAggregationQueryRequest toProto() {
        return this.toProto(null);
    }

    @Nonnull
    RunAggregationQueryRequest toProto(@Nullable ByteString transactionId) {
        RunQueryRequest runQueryRequest = this.query.toProto();
        RunAggregationQueryRequest.Builder request = RunAggregationQueryRequest.newBuilder();
        request.setParent(runQueryRequest.getParent());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        StructuredAggregationQuery.Builder structuredAggregationQuery = request.getStructuredAggregationQueryBuilder();
        structuredAggregationQuery.setStructuredQuery(runQueryRequest.getStructuredQuery());
        StructuredAggregationQuery.Aggregation.Builder aggregation = StructuredAggregationQuery.Aggregation.newBuilder();
        aggregation.setCount(StructuredAggregationQuery.Aggregation.Count.getDefaultInstance());
        aggregation.setAlias(ALIAS_COUNT);
        structuredAggregationQuery.addAggregations(aggregation);
        return request.build();
    }

    @Nonnull
    public static AggregateQuery fromProto(Firestore firestore, RunAggregationQueryRequest proto) {
        RunQueryRequest runQueryRequest = RunQueryRequest.newBuilder().setParent(proto.getParent()).setStructuredQuery(proto.getStructuredAggregationQuery().getStructuredQuery()).build();
        Query query = Query.fromProto(firestore, runQueryRequest);
        return new AggregateQuery(query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AggregateQuery)) {
            return false;
        }
        AggregateQuery other = (AggregateQuery)object;
        return this.query.equals(other.query);
    }

    private final class AggregateQueryResponseObserver
    implements ResponseObserver<RunAggregationQueryResponse> {
        private final AggregateQueryResponseDeliverer responseDeliverer;
        private StreamController streamController;

        AggregateQueryResponseObserver(AggregateQueryResponseDeliverer responseDeliverer) {
            this.responseDeliverer = responseDeliverer;
        }

        @Override
        public void onStart(StreamController streamController) {
            this.streamController = streamController;
        }

        @Override
        public void onResponse(RunAggregationQueryResponse response) {
            this.streamController.cancel();
            Timestamp readTime = Timestamp.fromProto(response.getReadTime());
            Value value = response.getResult().getAggregateFieldsMap().get(AggregateQuery.ALIAS_COUNT);
            if (value == null) {
                throw new IllegalArgumentException("RunAggregationQueryResponse is missing required alias: count");
            }
            if (value.getValueTypeCase() != Value.ValueTypeCase.INTEGER_VALUE) {
                throw new IllegalArgumentException("RunAggregationQueryResponse alias count has incorrect type: " + value.getValueTypeCase());
            }
            long count = value.getIntegerValue();
            this.responseDeliverer.deliverResult(count, readTime);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.shouldRetry(throwable)) {
                AggregateQuery.this.runQuery(this.responseDeliverer);
            } else {
                this.responseDeliverer.deliverError(throwable);
            }
        }

        private boolean shouldRetry(Throwable throwable) {
            Set<StatusCode.Code> retryableCodes = FirestoreSettings.newBuilder().runAggregationQuerySettings().getRetryableCodes();
            return AggregateQuery.this.query.shouldRetryQuery(throwable, this.responseDeliverer.getTransactionId(), this.responseDeliverer.getStartTimeNanos(), retryableCodes);
        }

        @Override
        public void onComplete() {
        }
    }

    private final class AggregateQueryResponseDeliverer {
        @Nullable
        private final ByteString transactionId;
        private final long startTimeNanos;
        private final SettableApiFuture<AggregateQuerySnapshot> future = SettableApiFuture.create();
        private final AtomicBoolean isFutureCompleted = new AtomicBoolean(false);

        AggregateQueryResponseDeliverer(ByteString transactionId, long startTimeNanos) {
            this.transactionId = transactionId;
            this.startTimeNanos = startTimeNanos;
        }

        ApiFuture<AggregateQuerySnapshot> getFuture() {
            return this.future;
        }

        @Nullable
        ByteString getTransactionId() {
            return this.transactionId;
        }

        long getStartTimeNanos() {
            return this.startTimeNanos;
        }

        void deliverResult(long count, Timestamp readTime) {
            if (this.isFutureCompleted.compareAndSet(false, true)) {
                this.future.set(new AggregateQuerySnapshot(AggregateQuery.this, readTime, count));
            }
        }

        void deliverError(Throwable throwable) {
            if (this.isFutureCompleted.compareAndSet(false, true)) {
                this.future.setException(throwable);
            }
        }
    }
}

