/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ExecutableHandler;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.PluggableAuthHandler;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.annotations.VisibleForTesting;

public class PluggableAuthCredentials
extends ExternalAccountCredentials {
    private final PluggableAuthCredentialSource config;
    private final ExecutableHandler handler;

    PluggableAuthCredentials(Builder builder) {
        super(builder);
        this.config = (PluggableAuthCredentialSource)builder.credentialSource;
        this.handler = builder.handler != null ? builder.handler : new PluggableAuthHandler(this.getEnvironmentProvider());
        this.overrideImpersonatedCredentials(this.buildImpersonatedCredentials());
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        String credential = this.retrieveSubjectToken();
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(credential, this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        final String executableCommand = this.config.getCommand();
        final String outputFilePath = this.config.getOutputFilePath();
        final int executableTimeoutMs = this.config.getTimeoutMs();
        final HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_AUDIENCE", this.getAudience());
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_TOKEN_TYPE", this.getSubjectTokenType());
        envMap.put("GOOGLE_EXTERNAL_ACCOUNT_INTERACTIVE", "0");
        if (this.getServiceAccountEmail() != null) {
            envMap.put("GOOGLE_EXTERNAL_ACCOUNT_IMPERSONATED_EMAIL", this.getServiceAccountEmail());
        }
        if (outputFilePath != null && !outputFilePath.isEmpty()) {
            envMap.put("GOOGLE_EXTERNAL_ACCOUNT_OUTPUT_FILE", outputFilePath);
        }
        ExecutableHandler.ExecutableOptions options = new ExecutableHandler.ExecutableOptions(){

            @Override
            public String getExecutableCommand() {
                return executableCommand;
            }

            @Override
            public Map<String, String> getEnvironmentMap() {
                return envMap;
            }

            @Override
            public int getExecutableTimeoutMs() {
                return executableTimeoutMs;
            }

            @Override
            @Nullable
            public String getOutputFilePath() {
                return outputFilePath;
            }
        };
        return this.handler.retrieveTokenFromExecutable(options);
    }

    @Override
    public PluggableAuthCredentials createScoped(Collection<String> newScopes) {
        return new PluggableAuthCredentials((Builder)PluggableAuthCredentials.newBuilder(this).setScopes(newScopes));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PluggableAuthCredentials pluggableAuthCredentials) {
        return new Builder(pluggableAuthCredentials);
    }

    @Nullable
    @VisibleForTesting
    ExecutableHandler getExecutableHandler() {
        return this.handler;
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        private ExecutableHandler handler;

        Builder() {
        }

        Builder(PluggableAuthCredentials credentials) {
            super(credentials);
            this.handler = credentials.handler;
        }

        public Builder setExecutableHandler(ExecutableHandler handler) {
            this.handler = handler;
            return this;
        }

        @Override
        public PluggableAuthCredentials build() {
            return new PluggableAuthCredentials(this);
        }
    }

    static class PluggableAuthCredentialSource
    extends ExternalAccountCredentials.CredentialSource {
        private static final int DEFAULT_EXECUTABLE_TIMEOUT_MS = 30000;
        private static final int MINIMUM_EXECUTABLE_TIMEOUT_MS = 5000;
        private static final int MAXIMUM_EXECUTABLE_TIMEOUT_MS = 120000;
        private static final String COMMAND_KEY = "command";
        private static final String TIMEOUT_MILLIS_KEY = "timeout_millis";
        private static final String OUTPUT_FILE_KEY = "output_file";
        private final String executableCommand;
        private final int executableTimeoutMs;
        @Nullable
        private final String outputFilePath;

        PluggableAuthCredentialSource(Map<String, Object> credentialSourceMap) {
            super(credentialSourceMap);
            Object timeout;
            if (!credentialSourceMap.containsKey("executable")) {
                throw new IllegalArgumentException("Invalid credential source for PluggableAuth credentials.");
            }
            Map executable = (Map)credentialSourceMap.get("executable");
            if (!executable.containsKey(COMMAND_KEY)) {
                throw new IllegalArgumentException("The PluggableAuthCredentialSource is missing the required 'command' field.");
            }
            this.executableTimeoutMs = executable.containsKey(TIMEOUT_MILLIS_KEY) ? ((timeout = executable.get(TIMEOUT_MILLIS_KEY)) instanceof BigDecimal ? ((BigDecimal)timeout).intValue() : (executable.get(TIMEOUT_MILLIS_KEY) instanceof Integer ? (Integer)timeout : Integer.parseInt((String)timeout))) : 30000;
            if (this.executableTimeoutMs < 5000 || this.executableTimeoutMs > 120000) {
                throw new IllegalArgumentException(String.format("The executable timeout must be between %s and %s milliseconds.", 5000, 120000));
            }
            this.executableCommand = (String)executable.get(COMMAND_KEY);
            this.outputFilePath = (String)executable.get(OUTPUT_FILE_KEY);
        }

        String getCommand() {
            return this.executableCommand;
        }

        int getTimeoutMs() {
            return this.executableTimeoutMs;
        }

        @Nullable
        String getOutputFilePath() {
            return this.outputFilePath;
        }
    }
}

