/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.internal;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableMap;

@InternalApi
public final class ApiCallContextOptions {
    private final ImmutableMap<ApiCallContext.Key, Object> options;
    private static final ApiCallContextOptions DEFAULT_OPTIONS = new ApiCallContextOptions(ImmutableMap.of());

    private ApiCallContextOptions(ImmutableMap<ApiCallContext.Key, Object> options) {
        this.options = Preconditions.checkNotNull(options);
    }

    public static ApiCallContextOptions getDefaultOptions() {
        return DEFAULT_OPTIONS;
    }

    public <T> ApiCallContextOptions withOption(ApiCallContext.Key<T> key, T value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        ImmutableMap.Builder<ApiCallContext.Key, Object> builder = ImmutableMap.builder();
        if (!this.options.containsKey(key)) {
            builder.putAll(this.options).put(key, value);
        } else {
            builder.put(key, value);
            for (ApiCallContext.Key oldKey : this.options.keySet()) {
                if (oldKey.equals(key)) continue;
                builder.put(oldKey, this.options.get(oldKey));
            }
        }
        return new ApiCallContextOptions(builder.build());
    }

    public <T> T getOption(ApiCallContext.Key<T> key) {
        Preconditions.checkNotNull(key);
        return (T)this.options.get(key);
    }

    public ApiCallContextOptions merge(ApiCallContextOptions newOptions) {
        Preconditions.checkNotNull(newOptions);
        ImmutableMap.Builder<ApiCallContext.Key, Object> builder = ImmutableMap.builder().putAll(newOptions.options);
        for (ApiCallContext.Key key : this.options.keySet()) {
            if (newOptions.options.containsKey(key)) continue;
            builder.put(key, this.options.get(key));
        }
        return new ApiCallContextOptions(builder.build());
    }
}

