/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.AutoValue_ErrorDetails;
import com.google.api.gax.rpc.ProtocolBufferParsingException;
import com.google.auto.value.AutoValue;
import com.google.rpc.BadRequest;
import com.google.rpc.DebugInfo;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Help;
import com.google.rpc.LocalizedMessage;
import com.google.rpc.PreconditionFailure;
import com.google.rpc.QuotaFailure;
import com.google.rpc.RequestInfo;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.Any;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.Message;

@AutoValue
public abstract class ErrorDetails {
    @Nullable
    public ErrorInfo getErrorInfo() {
        return this.unpack(ErrorInfo.class);
    }

    @Nullable
    public RetryInfo getRetryInfo() {
        return this.unpack(RetryInfo.class);
    }

    @Nullable
    public DebugInfo getDebugInfo() {
        return this.unpack(DebugInfo.class);
    }

    @Nullable
    public QuotaFailure getQuotaFailure() {
        return this.unpack(QuotaFailure.class);
    }

    @Nullable
    public PreconditionFailure getPreconditionFailure() {
        return this.unpack(PreconditionFailure.class);
    }

    @Nullable
    public BadRequest getBadRequest() {
        return this.unpack(BadRequest.class);
    }

    @Nullable
    public RequestInfo getRequestInfo() {
        return this.unpack(RequestInfo.class);
    }

    @Nullable
    public ResourceInfo getResourceInfo() {
        return this.unpack(ResourceInfo.class);
    }

    @Nullable
    public Help getHelp() {
        return this.unpack(Help.class);
    }

    @Nullable
    public LocalizedMessage getLocalizedMessage() {
        return this.unpack(LocalizedMessage.class);
    }

    @Nullable
    abstract List<Any> getRawErrorMessages();

    public static Builder builder() {
        return new AutoValue_ErrorDetails.Builder();
    }

    @VisibleForTesting
    <T extends Message> T unpack(Class<T> errorTypeClazz) {
        List<Any> rawErrorMessages = this.getRawErrorMessages();
        if (rawErrorMessages == null) {
            return null;
        }
        for (Any detail : rawErrorMessages) {
            if (!detail.is(errorTypeClazz)) continue;
            try {
                return detail.unpack(errorTypeClazz);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ProtocolBufferParsingException(String.format("Failed to unpack %s from raw error messages", errorTypeClazz.getSimpleName()), e);
            }
        }
        return null;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRawErrorMessages(List<Any> var1);

        public abstract ErrorDetails build();
    }
}

