/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.NonCancellableFuture;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.tracing.ApiTracer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.util.concurrent.AbstractFuture;
import org.apache.seatunnel.shade.google.firestore.com.google.common.util.concurrent.MoreExecutors;

class BasicRetryingFuture<ResponseT>
extends AbstractFuture<ResponseT>
implements RetryingFuture<ResponseT> {
    final Object lock = new Object();
    private final Callable<ResponseT> callable;
    private final RetryAlgorithm<ResponseT> retryAlgorithm;
    private final RetryingContext retryingContext;
    private volatile TimedAttemptSettings attemptSettings;
    private volatile ApiFuture<ResponseT> latestCompletedAttemptResult;
    private volatile ApiFuture<ResponseT> attemptResult;
    private static final Logger LOG = Logger.getLogger(BasicRetryingFuture.class.getName());

    BasicRetryingFuture(Callable<ResponseT> callable, RetryAlgorithm<ResponseT> retryAlgorithm, RetryingContext context) {
        this.callable = Preconditions.checkNotNull(callable);
        this.retryAlgorithm = Preconditions.checkNotNull(retryAlgorithm);
        this.retryingContext = Preconditions.checkNotNull(context);
        this.attemptSettings = retryAlgorithm.createFirstAttempt(context);
        super.addListener(new CompletionListener(), MoreExecutors.directExecutor());
    }

    @Override
    public void setAttemptFuture(ApiFuture<ResponseT> attemptFuture) {
        try {
            if (this.isDone()) {
                return;
            }
            Object response = attemptFuture.get();
            this.handleAttempt(null, response);
        }
        catch (ExecutionException e) {
            this.handleAttempt(e.getCause(), null);
        }
        catch (Throwable e) {
            this.handleAttempt(e, null);
        }
    }

    @Override
    public Callable<ResponseT> getCallable() {
        return this.callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimedAttemptSettings getAttemptSettings() {
        Object object = this.lock;
        synchronized (object) {
            return this.attemptSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<ResponseT> peekAttemptResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.latestCompletedAttemptResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<ResponseT> getAttemptResult() {
        Object object = this.lock;
        synchronized (object) {
            if (this.attemptResult == null) {
                this.attemptResult = new NonCancellableFuture();
            }
            return this.attemptResult;
        }
    }

    void clearAttemptServiceData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAttempt(Throwable throwable, ResponseT response) {
        ApiTracer tracer = this.retryingContext.getTracer();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.clearAttemptServiceData();
                if (throwable instanceof CancellationException) {
                    tracer.attemptCancelled();
                    super.cancel(false);
                } else if (throwable instanceof RejectedExecutionException) {
                    tracer.attemptPermanentFailure(throwable);
                    super.setException(throwable);
                }
                if (this.isDone()) {
                    return;
                }
                TimedAttemptSettings nextAttemptSettings = this.retryAlgorithm.createNextAttempt(this.retryingContext, throwable, response, this.attemptSettings);
                boolean shouldRetry = this.retryAlgorithm.shouldRetry(this.retryingContext, throwable, response, nextAttemptSettings);
                if (shouldRetry) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "Retrying with:\n{0}\n{1}\n{2}\n{3}", new Object[]{"enclosingMethod: " + (this.callable.getClass().getEnclosingMethod() != null ? this.callable.getClass().getEnclosingMethod().getName() : ""), "attemptCount: " + this.attemptSettings.getAttemptCount(), "delay: " + this.attemptSettings.getRetryDelay(), "retriableException: " + throwable});
                    }
                    tracer.attemptFailed(throwable, nextAttemptSettings.getRandomizedRetryDelay());
                    this.attemptSettings = nextAttemptSettings;
                    this.setAttemptResult(throwable, response, true);
                } else if (throwable != null) {
                    if (this.retryAlgorithm.shouldRetryBasedOnResult(this.retryingContext, throwable, response)) {
                        tracer.attemptFailedRetriesExhausted(throwable);
                    } else {
                        tracer.attemptPermanentFailure(throwable);
                    }
                    super.setException(throwable);
                } else {
                    tracer.attemptSucceeded();
                    super.set(response);
                }
            }
            catch (CancellationException e) {
                tracer.attemptFailedRetriesExhausted(e);
                super.cancel(false);
            }
            catch (Exception e) {
                tracer.attemptPermanentFailure(e);
                super.setException(e);
            }
        }
    }

    private void setAttemptResult(Throwable throwable, ResponseT response, boolean shouldRetry) {
        ApiFuture<ResponseT> prevAttemptResult = this.attemptResult;
        try {
            if (throwable instanceof CancellationException) {
                NonCancellableFuture future = new NonCancellableFuture();
                future.cancelPrivately();
                this.latestCompletedAttemptResult = future;
                ApiFuture<ResponseT> apiFuture = this.attemptResult = shouldRetry ? null : this.latestCompletedAttemptResult;
                if (prevAttemptResult instanceof NonCancellableFuture) {
                    ((NonCancellableFuture)prevAttemptResult).cancelPrivately();
                }
            } else if (throwable != null) {
                this.latestCompletedAttemptResult = ApiFutures.immediateFailedFuture(throwable);
                ApiFuture<ResponseT> apiFuture = this.attemptResult = shouldRetry ? null : this.latestCompletedAttemptResult;
                if (prevAttemptResult instanceof NonCancellableFuture) {
                    ((NonCancellableFuture)prevAttemptResult).setExceptionPrivately(throwable);
                }
            } else {
                this.latestCompletedAttemptResult = ApiFutures.immediateFuture(response);
                ApiFuture<ResponseT> apiFuture = this.attemptResult = shouldRetry ? null : this.latestCompletedAttemptResult;
                if (prevAttemptResult instanceof NonCancellableFuture) {
                    ((NonCancellableFuture)prevAttemptResult).setPrivately(response);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CompletionListener
    implements Runnable {
        private CompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = BasicRetryingFuture.this.lock;
            synchronized (object) {
                try {
                    BasicRetryingFuture.this.clearAttemptServiceData();
                    Object response = BasicRetryingFuture.this.get();
                    BasicRetryingFuture.this.setAttemptResult(null, response, false);
                }
                catch (ExecutionException e) {
                    BasicRetryingFuture.this.setAttemptResult(e.getCause(), null, false);
                }
                catch (Throwable e) {
                    BasicRetryingFuture.this.setAttemptResult(e, null, false);
                }
            }
        }
    }
}

