/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.RestSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.Message;
import org.apache.seatunnel.shade.google.firestore.com.google.protobuf.TypeRegistry;

public class ProtoMessageResponseParser<ResponseT extends Message>
implements HttpResponseParser<ResponseT> {
    private final ResponseT defaultInstance;
    private final TypeRegistry defaultRegistry;

    private ProtoMessageResponseParser(ResponseT defaultInstance, TypeRegistry defaultRegistry) {
        this.defaultInstance = defaultInstance;
        this.defaultRegistry = defaultRegistry;
    }

    public static <ResponseT extends Message> Builder<ResponseT> newBuilder() {
        return new Builder().setDefaultTypeRegistry(TypeRegistry.getEmptyTypeRegistry());
    }

    @Override
    public ResponseT parse(InputStream httpContent) {
        return (ResponseT)this.parse(httpContent, this.defaultRegistry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseT parse(InputStream httpContent, TypeRegistry registry) {
        try (InputStreamReader json = new InputStreamReader(httpContent, StandardCharsets.UTF_8);){
            Object object = this.parse(json, registry);
            return (ResponseT)object;
        }
        catch (IOException e) {
            throw new RestSerializationException("Failed to parse response message", e);
        }
    }

    @Override
    public ResponseT parse(Reader httpContent, TypeRegistry registry) {
        return (ResponseT)ProtoRestSerializer.create(registry).fromJson(httpContent, this.defaultInstance.newBuilderForType());
    }

    @Override
    public String serialize(ResponseT response) {
        return ProtoRestSerializer.create(this.defaultRegistry).toJson((Message)response, false);
    }

    /* synthetic */ ProtoMessageResponseParser(Message x0, TypeRegistry x1, 1 x2) {
        this(x0, x1);
    }

    public static class Builder<ResponseT extends Message> {
        private ResponseT defaultInstance;
        private TypeRegistry defaultRegistry;

        public Builder<ResponseT> setDefaultInstance(ResponseT defaultInstance) {
            this.defaultInstance = defaultInstance;
            return this;
        }

        public Builder<ResponseT> setDefaultTypeRegistry(TypeRegistry defaultRegistry) {
            this.defaultRegistry = defaultRegistry;
            return this;
        }

        public ProtoMessageResponseParser<ResponseT> build() {
            return new ProtoMessageResponseParser((Message)this.defaultInstance, this.defaultRegistry, null);
        }
    }
}

