/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.ApiCallContextOptions;
import com.google.api.gax.rpc.internal.Headers;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.auth.Credentials;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableMap;
import org.apache.seatunnel.shade.google.firestore.com.google.common.collect.ImmutableSet;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

@BetaApi(value="Reference ApiCallContext instead - this class is likely to experience breaking changes")
public final class HttpJsonCallContext
implements ApiCallContext {
    private final HttpJsonChannel channel;
    private final HttpJsonCallOptions callOptions;
    @Nullable
    private final Duration timeout;
    @Nullable
    private final Duration streamWaitTimeout;
    @Nullable
    private final Duration streamIdleTimeout;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiCallContextOptions options;
    private final ApiTracer tracer;
    @Nullable
    private final RetrySettings retrySettings;
    @Nullable
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    public static HttpJsonCallContext createDefault() {
        return new HttpJsonCallContext(null, HttpJsonCallOptions.newBuilder().build(), null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null);
    }

    public static HttpJsonCallContext of(HttpJsonChannel channel, HttpJsonCallOptions options) {
        return new HttpJsonCallContext(channel, options, null, null, null, ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null);
    }

    private HttpJsonCallContext(HttpJsonChannel channel, HttpJsonCallOptions callOptions, Duration timeout, Duration streamWaitTimeout, Duration streamIdleTimeout, ImmutableMap<String, List<String>> extraHeaders, ApiCallContextOptions options, ApiTracer tracer, RetrySettings defaultRetrySettings, Set<StatusCode.Code> defaultRetryableCodes) {
        this.channel = channel;
        this.callOptions = callOptions;
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.extraHeaders = extraHeaders;
        this.options = options;
        this.tracer = tracer;
        this.retrySettings = defaultRetrySettings;
        this.retryableCodes = defaultRetryableCodes == null ? null : ImmutableSet.copyOf(defaultRetryableCodes);
    }

    @Override
    public HttpJsonCallContext nullToSelf(ApiCallContext inputContext) {
        HttpJsonCallContext httpJsonCallContext;
        if (inputContext == null) {
            httpJsonCallContext = this;
        } else {
            if (!(inputContext instanceof HttpJsonCallContext)) {
                throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputContext.getClass().getName());
            }
            httpJsonCallContext = (HttpJsonCallContext)inputContext;
        }
        return httpJsonCallContext;
    }

    @Override
    public HttpJsonCallContext merge(ApiCallContext inputCallContext) {
        ImmutableSet<StatusCode.Code> newRetryableCodes;
        RetrySettings newRetrySettings;
        Duration newStreamIdleTimeout;
        Duration newStreamWaitTimeout;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof HttpJsonCallContext)) {
            throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputCallContext.getClass().getName());
        }
        HttpJsonCallContext httpJsonCallContext = (HttpJsonCallContext)inputCallContext;
        HttpJsonChannel newChannel = httpJsonCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        HttpJsonCallOptions newCallOptions = this.callOptions.merge(httpJsonCallContext.callOptions);
        Duration newTimeout = httpJsonCallContext.timeout;
        if (newTimeout == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = httpJsonCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = httpJsonCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, httpJsonCallContext.extraHeaders);
        ApiCallContextOptions newOptions = this.options.merge(httpJsonCallContext.options);
        ApiTracer newTracer = httpJsonCallContext.tracer;
        if (newTracer == null) {
            newTracer = this.tracer;
        }
        if ((newRetrySettings = httpJsonCallContext.retrySettings) == null) {
            newRetrySettings = this.retrySettings;
        }
        if ((newRetryableCodes = httpJsonCallContext.retryableCodes) == null) {
            newRetryableCodes = this.retryableCodes;
        }
        return new HttpJsonCallContext(newChannel, newCallOptions, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, newExtraHeaders, newOptions, newTracer, newRetrySettings, newRetryableCodes);
    }

    @Override
    public HttpJsonCallContext withCredentials(Credentials newCredentials) {
        HttpJsonCallOptions.Builder builder = this.callOptions != null ? this.callOptions.toBuilder() : HttpJsonCallOptions.newBuilder();
        return this.withCallOptions(builder.setCredentials(newCredentials).build());
    }

    @Override
    public HttpJsonCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull(inputChannel);
        if (!(inputChannel instanceof HttpJsonTransportChannel)) {
            throw new IllegalArgumentException("Expected HttpJsonTransportChannel, got " + inputChannel.getClass().getName());
        }
        HttpJsonTransportChannel transportChannel = (HttpJsonTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    @Override
    public HttpJsonCallContext withTimeout(Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new HttpJsonCallContext(this.channel, this.callOptions, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public HttpJsonCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        if (streamWaitTimeout != null) {
            Preconditions.checkArgument(streamWaitTimeout.compareTo(Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }

    @Override
    @Nullable
    public Duration getStreamWaitTimeout() {
        return this.streamWaitTimeout;
    }

    @Override
    public HttpJsonCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        if (streamIdleTimeout != null) {
            Preconditions.checkArgument(streamIdleTimeout.compareTo(Duration.ZERO) >= 0, "Invalid timeout: < 0 s");
        }
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }

    @Override
    @Nullable
    public Duration getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public ApiCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap<String, List<String>> newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, newExtraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }

    @Override
    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    @Override
    public <T> ApiCallContext withOption(ApiCallContext.Key<T> key, T value) {
        ApiCallContextOptions newOptions = this.options.withOption(key, value);
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, newOptions, this.tracer, this.retrySettings, this.retryableCodes);
    }

    @Override
    public <T> T getOption(ApiCallContext.Key<T> key) {
        return this.options.getOption(key);
    }

    public HttpJsonChannel getChannel() {
        return this.channel;
    }

    public HttpJsonCallOptions getCallOptions() {
        return this.callOptions;
    }

    @Deprecated
    @Nullable
    public Instant getDeadline() {
        return this.getCallOptions() != null ? this.getCallOptions().getDeadline() : null;
    }

    @Deprecated
    @Nullable
    public Credentials getCredentials() {
        return this.getCallOptions() != null ? this.getCallOptions().getCredentials() : null;
    }

    @Override
    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    @Override
    public HttpJsonCallContext withRetrySettings(RetrySettings retrySettings) {
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, retrySettings, this.retryableCodes);
    }

    @Override
    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    @Override
    public HttpJsonCallContext withRetryableCodes(Set<StatusCode.Code> retryableCodes) {
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, retryableCodes);
    }

    public HttpJsonCallContext withChannel(HttpJsonChannel newChannel) {
        return new HttpJsonCallContext(newChannel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }

    public HttpJsonCallContext withCallOptions(HttpJsonCallOptions newCallOptions) {
        return new HttpJsonCallContext(this.channel, newCallOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }

    @Deprecated
    public HttpJsonCallContext withDeadline(Instant newDeadline) {
        HttpJsonCallOptions.Builder builder = this.callOptions != null ? this.callOptions.toBuilder() : HttpJsonCallOptions.newBuilder();
        return this.withCallOptions(builder.setDeadline(newDeadline).build());
    }

    @Override
    @Nonnull
    public ApiTracer getTracer() {
        if (this.tracer == null) {
            return BaseApiTracer.getInstance();
        }
        return this.tracer;
    }

    @Override
    public HttpJsonCallContext withTracer(@Nonnull ApiTracer newTracer) {
        Preconditions.checkNotNull(newTracer);
        return new HttpJsonCallContext(this.channel, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.extraHeaders, this.options, newTracer, this.retrySettings, this.retryableCodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpJsonCallContext that = (HttpJsonCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.callOptions, that.callOptions) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.extraHeaders, that.extraHeaders) && Objects.equals(this.options, that.options) && Objects.equals(this.tracer, that.tracer) && Objects.equals(this.retrySettings, that.retrySettings) && Objects.equals(this.retryableCodes, that.retryableCodes);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.callOptions, this.timeout, this.extraHeaders, this.options, this.tracer, this.retrySettings, this.retryableCodes);
    }
}

