/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.nativeimage;

import com.google.api.gax.nativeimage.NativeImageUtils;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

final class ProtobufMessageFeature
implements Feature {
    private static final String PROTO_MESSAGE_CLASS = "org.apache.seatunnel.shade.google.firestore.com.google.protobuf.GeneratedMessageV3";
    private static final String PROTO_ENUM_CLASS = "org.apache.seatunnel.shade.google.firestore.com.google.protobuf.ProtocolMessageEnum";
    private static final String ENUM_VAL_DESCRIPTOR_CLASS = "org.apache.seatunnel.shade.google.firestore.com.google.protobuf.Descriptors$EnumValueDescriptor";
    private static final List<String> METHOD_ACCESSOR_PREFIXES = Arrays.asList("get", "set", "has", "add", "clear", "newBuilder");

    ProtobufMessageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class protoEnumClass;
        Class protoMessageClass = access.findClassByName(PROTO_MESSAGE_CLASS);
        if (protoMessageClass != null) {
            Method internalAccessorMethod = NativeImageUtils.getMethodOrFail(protoMessageClass, "internalGetFieldAccessorTable", new Class[0]);
            access.registerMethodOverrideReachabilityHandler((duringAccess, method) -> {
                ProtobufMessageFeature.registerFieldAccessors(method.getDeclaringClass());
                ProtobufMessageFeature.registerFieldAccessors(ProtobufMessageFeature.getBuilderClass(method.getDeclaringClass()));
            }, (Executable)internalAccessorMethod);
        }
        if ((protoEnumClass = access.findClassByName(PROTO_ENUM_CLASS)) != null) {
            access.registerSubtypeReachabilityHandler((duringAccess, subtypeClass) -> {
                if (!PROTO_ENUM_CLASS.equals(subtypeClass.getName())) {
                    Method method = NativeImageUtils.getMethodOrFail(subtypeClass, "valueOf", duringAccess.findClassByName(ENUM_VAL_DESCRIPTOR_CLASS));
                    RuntimeReflection.register((Executable[])new Executable[]{method});
                    method = NativeImageUtils.getMethodOrFail(subtypeClass, "getValueDescriptor", new Class[0]);
                    RuntimeReflection.register((Executable[])new Executable[]{method});
                }
            }, protoEnumClass);
        }
    }

    private static void registerFieldAccessors(Class<?> protoClass) {
        for (Method method : protoClass.getMethods()) {
            boolean hasAccessorPrefix = METHOD_ACCESSOR_PREFIXES.stream().anyMatch(prefix -> method.getName().startsWith((String)prefix));
            if (!hasAccessorPrefix) continue;
            RuntimeReflection.register((Executable[])new Executable[]{method});
        }
    }

    private static Class<?> getBuilderClass(Class<?> protoClass) {
        for (Class<?> clazz : protoClass.getClasses()) {
            if (!clazz.getName().endsWith("Builder")) continue;
            return clazz;
        }
        return null;
    }
}

