/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.AutoValue_ChannelPoolSettings;
import com.google.auto.value.AutoValue;
import java.time.Duration;
import org.apache.seatunnel.shade.google.firestore.com.google.common.base.Preconditions;

@BetaApi(value="surface for channel pool sizing is not yet stable")
@AutoValue
public abstract class ChannelPoolSettings {
    static final Duration RESIZE_INTERVAL = Duration.ofMinutes(1L);
    static final int MAX_RESIZE_DELTA = 2;

    public abstract int getMinRpcsPerChannel();

    public abstract int getMaxRpcsPerChannel();

    public abstract int getMinChannelCount();

    public abstract int getMaxChannelCount();

    public abstract int getInitialChannelCount();

    public abstract boolean isPreemptiveRefreshEnabled();

    boolean isStaticSize() {
        if (this.getMinChannelCount() == this.getMaxChannelCount()) {
            return true;
        }
        return this.getMinRpcsPerChannel() == 0 && this.getMaxRpcsPerChannel() == Integer.MAX_VALUE;
    }

    public abstract Builder toBuilder();

    public static ChannelPoolSettings staticallySized(int size) {
        return ChannelPoolSettings.builder().setInitialChannelCount(size).setMinRpcsPerChannel(0).setMaxRpcsPerChannel(Integer.MAX_VALUE).setMinChannelCount(size).setMaxChannelCount(size).build();
    }

    public static Builder builder() {
        return new AutoValue_ChannelPoolSettings.Builder().setInitialChannelCount(1).setMinChannelCount(1).setMaxChannelCount(200).setMinRpcsPerChannel(0).setMaxRpcsPerChannel(Integer.MAX_VALUE).setPreemptiveRefreshEnabled(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMinRpcsPerChannel(int var1);

        public abstract Builder setMaxRpcsPerChannel(int var1);

        public abstract Builder setMinChannelCount(int var1);

        public abstract Builder setMaxChannelCount(int var1);

        public abstract Builder setInitialChannelCount(int var1);

        public abstract Builder setPreemptiveRefreshEnabled(boolean var1);

        abstract ChannelPoolSettings autoBuild();

        public ChannelPoolSettings build() {
            ChannelPoolSettings s2 = this.autoBuild();
            Preconditions.checkState(s2.getMinRpcsPerChannel() <= s2.getMaxRpcsPerChannel(), "rpcsPerChannel range is invalid");
            Preconditions.checkState(s2.getMinChannelCount() > 0, "Minimum channel count must be at least 1");
            Preconditions.checkState(s2.getMinChannelCount() <= s2.getMaxRpcsPerChannel(), "absolute channel range is invalid");
            Preconditions.checkState(s2.getMinChannelCount() <= s2.getInitialChannelCount(), "initial channel count be at least minChannelCount");
            Preconditions.checkState(s2.getInitialChannelCount() <= s2.getMaxChannelCount(), "initial channel count must be less than maxChannelCount");
            Preconditions.checkState(s2.getInitialChannelCount() > 0, "Initial channel count must be greater than 0");
            return s2;
        }
    }
}

