/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.common.base.CharMatcher;
import autovalue.shaded.com.google.common.base.Verify;
import autovalue.shaded.com.google.common.collect.ImmutableCollection;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableListMultimap;
import autovalue.shaded.com.google.common.collect.Iterables;
import autovalue.shaded.com.google.common.primitives.Chars;
import autovalue.shaded.com.google.common.primitives.Ints;
import autovalue.shaded.com.google.escapevelocity.ConstantExpressionNode;
import autovalue.shaded.com.google.escapevelocity.DirectiveNode;
import autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import autovalue.shaded.com.google.escapevelocity.ExpressionNode;
import autovalue.shaded.com.google.escapevelocity.Node;
import autovalue.shaded.com.google.escapevelocity.ParseException;
import autovalue.shaded.com.google.escapevelocity.ReferenceNode;
import autovalue.shaded.com.google.escapevelocity.Reparser;
import autovalue.shaded.com.google.escapevelocity.Template;
import autovalue.shaded.com.google.escapevelocity.TokenNode;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.List;

class Parser {
    private static final int EOF = -1;
    private final LineNumberReader reader;
    private final String resourceName;
    private final Template.ResourceOpener resourceOpener;
    private int c;
    private int pushback = -1;
    private static final ImmutableListMultimap<Integer, Operator> CODE_POINT_TO_OPERATORS;
    private static final CharMatcher ASCII_LETTER;
    private static final CharMatcher ASCII_DIGIT;
    private static final CharMatcher ID_CHAR;

    Parser(Reader reader, String resourceName, Template.ResourceOpener resourceOpener) throws IOException {
        this.reader = new LineNumberReader(reader);
        this.reader.setLineNumber(1);
        this.next();
        this.resourceName = resourceName;
        this.resourceOpener = resourceOpener;
    }

    Template parse() throws IOException {
        ImmutableList<Node> tokens = this.parseTokens();
        return new Reparser(tokens).reparse();
    }

    private ImmutableList<Node> parseTokens() throws IOException {
        Node token;
        ImmutableList.Builder tokens = ImmutableList.builder();
        do {
            token = this.parseNode();
            tokens.add(token);
        } while (!(token instanceof TokenNode.EofNode));
        return tokens.build();
    }

    private int lineNumber() {
        return this.reader.getLineNumber();
    }

    private void next() throws IOException {
        if (this.c != -1) {
            if (this.pushback < 0) {
                this.c = this.reader.read();
            } else {
                this.c = this.pushback;
                this.pushback = -1;
            }
        }
    }

    private void pushback(int c1) {
        this.pushback = this.c;
        this.c = c1;
    }

    private void skipSpace() throws IOException {
        while (Character.isWhitespace(this.c)) {
            this.next();
        }
    }

    private void nextNonSpace() throws IOException {
        this.next();
        this.skipSpace();
    }

    private void expect(char expected) throws IOException {
        this.skipSpace();
        if (this.c != expected) {
            throw this.parseException("Expected " + expected);
        }
        this.next();
    }

    private Node parseNode() throws IOException {
        if (this.c == 35) {
            this.next();
            switch (this.c) {
                case 35: {
                    return this.parseLineComment();
                }
                case 42: {
                    return this.parseBlockComment();
                }
                case 91: {
                    return this.parseHashSquare();
                }
                case 123: {
                    return this.parseDirective();
                }
            }
            if (Parser.isAsciiLetter(this.c)) {
                return this.parseDirective();
            }
            return this.parsePlainText(35);
        }
        if (this.c == -1) {
            return new TokenNode.EofNode(this.resourceName, this.lineNumber());
        }
        return this.parseNonDirective();
    }

    private Node parseHashSquare() throws IOException {
        assert (this.c == 91);
        this.next();
        if (this.c != 91) {
            return this.parsePlainText(new StringBuilder("#["));
        }
        int startLine = this.lineNumber();
        this.next();
        StringBuilder sb = new StringBuilder();
        while (true) {
            int len;
            if (this.c == -1) {
                throw new ParseException("Unterminated #[[ - did not see matching ]]#", this.resourceName, startLine);
            }
            if (this.c == 35 && (len = sb.length()) > 1 && sb.charAt(len - 1) == ']' && sb.charAt(len - 2) == ']') break;
            sb.append((char)this.c);
            this.next();
        }
        this.next();
        String quoted = sb.substring(0, sb.length() - 2);
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), quoted);
    }

    private Node parseNonDirective() throws IOException {
        if (this.c == 36) {
            this.next();
            if (Parser.isAsciiLetter(this.c) || this.c == 123) {
                return this.parseReference();
            }
            return this.parsePlainText(36);
        }
        int firstChar = this.c;
        this.next();
        return this.parsePlainText(firstChar);
    }

    private Node parseDirective() throws IOException {
        Node node;
        String directive;
        if (this.c == 123) {
            this.next();
            directive = this.parseId("Directive inside #{...}");
            this.expect('}');
        } else {
            directive = this.parseId("Directive");
        }
        switch (directive) {
            case "end": {
                node = new TokenNode.EndTokenNode(this.resourceName, this.lineNumber());
                break;
            }
            case "if": 
            case "elseif": {
                node = this.parseIfOrElseIf(directive);
                break;
            }
            case "else": {
                node = new TokenNode.ElseTokenNode(this.resourceName, this.lineNumber());
                break;
            }
            case "foreach": {
                node = this.parseForEach();
                break;
            }
            case "set": {
                node = this.parseSet();
                break;
            }
            case "parse": {
                node = this.parseParse();
                break;
            }
            case "macro": {
                node = this.parseMacroDefinition();
                break;
            }
            default: {
                node = this.parsePossibleMacroCall(directive);
            }
        }
        if (this.c == 10) {
            this.next();
        }
        return node;
    }

    private Node parseIfOrElseIf(String directive) throws IOException {
        this.expect('(');
        ExpressionNode condition = this.parseExpression();
        this.expect(')');
        return directive.equals("if") ? new TokenNode.IfTokenNode(condition) : new TokenNode.ElseIfTokenNode(condition);
    }

    private Node parseForEach() throws IOException {
        this.expect('(');
        this.expect('$');
        String var = this.parseId("For-each variable");
        this.skipSpace();
        boolean bad = false;
        if (this.c != 105) {
            bad = true;
        } else {
            this.next();
            if (this.c != 110) {
                bad = true;
            }
        }
        if (bad) {
            throw this.parseException("Expected 'in' for #foreach");
        }
        this.next();
        ExpressionNode collection = this.parseExpression();
        this.expect(')');
        return new TokenNode.ForEachTokenNode(var, collection);
    }

    private Node parseSet() throws IOException {
        this.expect('(');
        this.expect('$');
        String var = this.parseId("#set variable");
        this.expect('=');
        ExpressionNode expression = this.parseExpression();
        this.expect(')');
        return new DirectiveNode.SetNode(var, expression);
    }

    private Node parseParse() throws IOException {
        this.expect('(');
        this.skipSpace();
        if (this.c != 34 && this.c != 39) {
            throw this.parseException("#parse only supported with string literal argument");
        }
        ExpressionNode nestedResourceNameExpression = this.parseStringLiteral(this.c, false);
        String nestedResourceName = nestedResourceNameExpression.evaluate(null).toString();
        this.expect(')');
        try (Reader nestedReader = this.resourceOpener.openResource(nestedResourceName);){
            Parser nestedParser = new Parser(nestedReader, nestedResourceName, this.resourceOpener);
            ImmutableList<Node> nestedTokens = nestedParser.parseTokens();
            TokenNode.NestedTokenNode nestedTokenNode = new TokenNode.NestedTokenNode(nestedResourceName, nestedTokens);
            return nestedTokenNode;
        }
    }

    private Node parseMacroDefinition() throws IOException {
        this.expect('(');
        this.skipSpace();
        String name = this.parseId("Macro name");
        ImmutableList.Builder parameterNames = ImmutableList.builder();
        while (true) {
            this.skipSpace();
            if (this.c == 41) break;
            if (this.c == 44) {
                this.next();
                this.skipSpace();
            }
            if (this.c != 36) {
                throw this.parseException("Macro parameters should look like $name");
            }
            this.next();
            parameterNames.add(this.parseId("Macro parameter name"));
        }
        this.next();
        return new TokenNode.MacroDefinitionTokenNode(this.resourceName, this.lineNumber(), name, (List<String>)((Object)parameterNames.build()));
    }

    private Node parsePossibleMacroCall(String directive) throws IOException {
        this.skipSpace();
        if (this.c != 40) {
            throw this.parseException("Unrecognized directive #" + directive);
        }
        this.next();
        ImmutableList.Builder parameterNodes = ImmutableList.builder();
        while (true) {
            this.skipSpace();
            if (this.c == 41) break;
            parameterNodes.add(this.parsePrimary());
            if (this.c != 44) continue;
            this.next();
        }
        this.next();
        return new DirectiveNode.MacroCallNode(this.resourceName, this.lineNumber(), directive, (ImmutableList<Node>)parameterNodes.build());
    }

    private Node parseLineComment() throws IOException {
        int lineNumber = this.lineNumber();
        while (this.c != 10 && this.c != -1) {
            this.next();
        }
        this.next();
        return new TokenNode.CommentTokenNode(this.resourceName, lineNumber);
    }

    private Node parseBlockComment() throws IOException {
        assert (this.c == 42);
        int startLine = this.lineNumber();
        int lastC = 0;
        this.next();
        while ((lastC != 42 || this.c != 35) && this.c != -1) {
            lastC = this.c;
            this.next();
        }
        this.next();
        return new TokenNode.CommentTokenNode(this.resourceName, startLine);
    }

    private Node parsePlainText(int firstChar) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.appendCodePoint(firstChar);
        return this.parsePlainText(sb);
    }

    private Node parsePlainText(StringBuilder sb) throws IOException {
        block3: while (true) {
            switch (this.c) {
                case -1: 
                case 35: 
                case 36: {
                    break block3;
                }
                default: {
                    sb.appendCodePoint(this.c);
                    this.next();
                    continue block3;
                }
            }
            break;
        }
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), sb.toString());
    }

    private Node parseReference() throws IOException {
        if (this.c == 123) {
            this.next();
            if (!Parser.isAsciiLetter(this.c)) {
                return this.parsePlainText(new StringBuilder("${"));
            }
            ReferenceNode node = this.parseReferenceNoBrace();
            this.expect('}');
            return node;
        }
        return this.parseReferenceNoBrace();
    }

    private ReferenceNode parseRequiredReference() throws IOException {
        if (this.c == 123) {
            this.next();
            ReferenceNode node = this.parseReferenceNoBrace();
            this.expect('}');
            return node;
        }
        return this.parseReferenceNoBrace();
    }

    private ReferenceNode parseReferenceNoBrace() throws IOException {
        String id = this.parseId("Reference");
        ReferenceNode.PlainReferenceNode lhs = new ReferenceNode.PlainReferenceNode(this.resourceName, this.lineNumber(), id);
        return this.parseReferenceSuffix(lhs);
    }

    private ReferenceNode parseReferenceSuffix(ReferenceNode lhs) throws IOException {
        switch (this.c) {
            case 46: {
                return this.parseReferenceMember(lhs);
            }
            case 91: {
                return this.parseReferenceIndex(lhs);
            }
        }
        return lhs;
    }

    private ReferenceNode parseReferenceMember(ReferenceNode lhs) throws IOException {
        assert (this.c == 46);
        this.next();
        if (!Parser.isAsciiLetter(this.c)) {
            this.pushback(46);
            return lhs;
        }
        String id = this.parseId("Member");
        ReferenceNode reference = this.c == 40 ? this.parseReferenceMethodParams(lhs, id) : new ReferenceNode.MemberReferenceNode(lhs, id);
        return this.parseReferenceSuffix(reference);
    }

    private ReferenceNode parseReferenceMethodParams(ReferenceNode lhs, String id) throws IOException {
        assert (this.c == 40);
        this.nextNonSpace();
        ImmutableList.Builder args2 = ImmutableList.builder();
        if (this.c != 41) {
            args2.add(this.parseExpression());
            while (this.c == 44) {
                this.nextNonSpace();
                args2.add(this.parseExpression());
            }
            if (this.c != 41) {
                throw this.parseException("Expected )");
            }
        }
        assert (this.c == 41);
        this.next();
        return new ReferenceNode.MethodReferenceNode(lhs, id, (List<ExpressionNode>)((Object)args2.build()));
    }

    private ReferenceNode parseReferenceIndex(ReferenceNode lhs) throws IOException {
        assert (this.c == 91);
        this.next();
        ExpressionNode index = this.parseExpression();
        if (this.c != 93) {
            throw this.parseException("Expected ]");
        }
        this.next();
        ReferenceNode.IndexReferenceNode reference = new ReferenceNode.IndexReferenceNode(lhs, index);
        return this.parseReferenceSuffix(reference);
    }

    private ExpressionNode parseExpression() throws IOException {
        ExpressionNode lhs = this.parseUnaryExpression();
        return new OperatorParser().parse(lhs, 1);
    }

    private ExpressionNode parseUnaryExpression() throws IOException {
        this.skipSpace();
        if (this.c == 40) {
            this.nextNonSpace();
            ExpressionNode node = this.parseExpression();
            this.expect(')');
            this.skipSpace();
            return node;
        }
        if (this.c == 33) {
            this.next();
            ExpressionNode.NotExpressionNode node = new ExpressionNode.NotExpressionNode(this.parseUnaryExpression());
            this.skipSpace();
            return node;
        }
        return this.parsePrimary();
    }

    private ExpressionNode parsePrimary() throws IOException {
        ExpressionNode node;
        if (this.c == 36) {
            this.next();
            node = this.parseRequiredReference();
        } else if (this.c == 34) {
            node = this.parseStringLiteral(this.c, true);
        } else if (this.c == 39) {
            node = this.parseStringLiteral(this.c, false);
        } else if (this.c == 45) {
            this.next();
            node = this.parseIntLiteral("-");
        } else if (Parser.isAsciiDigit(this.c)) {
            node = this.parseIntLiteral("");
        } else if (Parser.isAsciiLetter(this.c)) {
            node = this.parseBooleanLiteral();
        } else {
            throw this.parseException("Expected an expression");
        }
        this.skipSpace();
        return node;
    }

    private ExpressionNode parseStringLiteral(int quote, boolean allowReferences) throws IOException {
        assert (this.c == quote);
        this.next();
        ImmutableList.Builder nodes = ImmutableList.builder();
        StringBuilder sb = new StringBuilder();
        block5: while (this.c != quote) {
            switch (this.c) {
                case -1: 
                case 10: {
                    throw this.parseException("Unterminated string constant");
                }
                case 92: {
                    throw this.parseException("Escapes in string constants are not currently supported");
                }
                case 36: {
                    if (!allowReferences) break;
                    if (sb.length() > 0) {
                        nodes.add(new ConstantExpressionNode(this.resourceName, this.lineNumber(), sb.toString()));
                        sb.setLength(0);
                    }
                    this.next();
                    nodes.add(this.parseReference());
                    continue block5;
                }
            }
            sb.appendCodePoint(this.c);
            this.next();
        }
        this.next();
        if (sb.length() > 0) {
            nodes.add(new ConstantExpressionNode(this.resourceName, this.lineNumber(), sb.toString()));
        }
        return new StringLiteralNode(this.resourceName, this.lineNumber(), (ImmutableList<Node>)nodes.build());
    }

    private ExpressionNode parseIntLiteral(String prefix) throws IOException {
        StringBuilder sb = new StringBuilder(prefix);
        while (Parser.isAsciiDigit(this.c)) {
            sb.appendCodePoint(this.c);
            this.next();
        }
        Integer value = Ints.tryParse(sb.toString());
        if (value == null) {
            throw this.parseException("Invalid integer: " + sb);
        }
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), value);
    }

    private ExpressionNode parseBooleanLiteral() throws IOException {
        boolean value;
        String s2 = this.parseId("Identifier without $");
        if (s2.equals("true")) {
            value = true;
        } else if (s2.equals("false")) {
            value = false;
        } else {
            throw this.parseException("Identifier in expression must be preceded by $ or be true or false");
        }
        return new ConstantExpressionNode(this.resourceName, this.lineNumber(), value);
    }

    private static boolean isAsciiLetter(int c) {
        return (char)c == c && ASCII_LETTER.matches((char)c);
    }

    private static boolean isAsciiDigit(int c) {
        return (char)c == c && ASCII_DIGIT.matches((char)c);
    }

    private static boolean isIdChar(int c) {
        return (char)c == c && ID_CHAR.matches((char)c);
    }

    private String parseId(String what) throws IOException {
        if (!Parser.isAsciiLetter(this.c)) {
            throw this.parseException(what + " should start with an ASCII letter");
        }
        StringBuilder id = new StringBuilder();
        while (Parser.isIdChar(this.c)) {
            id.appendCodePoint(this.c);
            this.next();
        }
        return id.toString();
    }

    private ParseException parseException(String message) throws IOException {
        StringBuilder context = new StringBuilder();
        if (this.c == -1) {
            context.append("EOF");
        } else {
            for (int count = 0; this.c != -1 && count < 20; ++count) {
                context.appendCodePoint(this.c);
                this.next();
            }
            if (this.c != -1) {
                context.append("...");
            }
        }
        return new ParseException(message, this.resourceName, this.lineNumber(), context.toString());
    }

    static {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Operator operator : Operator.values()) {
            if (operator == Operator.STOP) continue;
            builder.put((Object)operator.symbol.charAt(0), (Object)operator);
        }
        CODE_POINT_TO_OPERATORS = builder.build();
        ASCII_LETTER = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z')).precomputed();
        ASCII_DIGIT = CharMatcher.inRange('0', '9').precomputed();
        ID_CHAR = ASCII_LETTER.or(ASCII_DIGIT).or(CharMatcher.anyOf("-_")).precomputed();
    }

    private static class StringLiteralNode
    extends ExpressionNode {
        private final ImmutableList<Node> nodes;

        StringLiteralNode(String resourceName, int lineNumber, ImmutableList<Node> nodes) {
            super(resourceName, lineNumber);
            this.nodes = nodes;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            StringBuilder sb = new StringBuilder();
            for (Node node : this.nodes) {
                sb.append(node.evaluate(context));
            }
            return sb.toString();
        }
    }

    private class OperatorParser {
        private Operator currentOperator;

        OperatorParser() throws IOException {
            this.nextOperator();
        }

        ExpressionNode parse(ExpressionNode lhs, int minPrecedence) throws IOException {
            while (this.currentOperator.precedence >= minPrecedence) {
                Operator operator = this.currentOperator;
                ExpressionNode rhs = Parser.this.parseUnaryExpression();
                this.nextOperator();
                while (this.currentOperator.precedence > operator.precedence) {
                    rhs = this.parse(rhs, this.currentOperator.precedence);
                }
                lhs = new ExpressionNode.BinaryExpressionNode(lhs, operator, rhs);
            }
            return lhs;
        }

        private void nextOperator() throws IOException {
            Parser.this.skipSpace();
            ImmutableCollection possibleOperators = CODE_POINT_TO_OPERATORS.get((Object)Parser.this.c);
            if (possibleOperators.isEmpty()) {
                this.currentOperator = Operator.STOP;
                return;
            }
            char firstChar = Chars.checkedCast(Parser.this.c);
            Parser.this.next();
            Operator operator = null;
            for (Operator possibleOperator : possibleOperators) {
                if (possibleOperator.symbol.length() == 1) {
                    Verify.verify(operator == null);
                    operator = possibleOperator;
                    continue;
                }
                if (possibleOperator.symbol.charAt(1) != Parser.this.c) continue;
                Parser.this.next();
                operator = possibleOperator;
            }
            if (operator == null) {
                throw Parser.this.parseException("Expected " + Iterables.getOnlyElement(possibleOperators) + ", not just " + firstChar);
            }
            this.currentOperator = operator;
        }
    }

    static enum Operator {
        STOP("", 0),
        OR("||", 1),
        AND("&&", 2),
        EQUAL("==", 3),
        NOT_EQUAL("!=", 3),
        LESS("<", 4),
        LESS_OR_EQUAL("<=", 4),
        GREATER(">", 4),
        GREATER_OR_EQUAL(">=", 4),
        PLUS("+", 5),
        MINUS("-", 5),
        TIMES("*", 6),
        DIVIDE("/", 6),
        REMAINDER("%", 6);

        final String symbol;
        final int precedence;

        private Operator(String symbol, int precedence) {
            this.symbol = symbol;
            this.precedence = precedence;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

