/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.ogg;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.MetadataUtil;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public class OggJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "Ogg";
    private static final String FIELD_TYPE = "op_type";
    private static final String FIELD_DATABASE_TABLE = "table";
    private static final String FIELD_TS = "op_ts";
    private static final String DATA_BEFORE = "before";
    private static final String DATA_AFTER = "after";
    private static final String OP_INSERT = "I";
    private static final String OP_UPDATE = "U";
    private static final String OP_DELETE = "D";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s operation message is null, if you are using Ogg Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    private final String database;
    private final String table;
    private final String[] fieldNames;
    private final int fieldCount;
    private final boolean ignoreParseErrors;
    private final Pattern databasePattern;
    private final Pattern tablePattern;
    private final JsonDeserializationSchema jsonDeserializer;
    private final SeaTunnelRowType seaTunnelRowType;
    private final CatalogTable catalogTable;

    public OggJsonDeserializationSchema(@NonNull CatalogTable catalogTable, String database, String table, boolean ignoreParseErrors) {
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        this.catalogTable = catalogTable;
        this.seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        this.jsonDeserializer = new JsonDeserializationSchema(catalogTable, false, ignoreParseErrors);
        this.database = database;
        this.table = table;
        this.fieldNames = this.seaTunnelRowType.getFieldNames();
        this.fieldCount = this.seaTunnelRowType.getTotalFields();
        this.ignoreParseErrors = ignoreParseErrors;
        this.databasePattern = database == null ? null : Pattern.compile(database);
        this.tablePattern = table == null ? null : Pattern.compile(table);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.seaTunnelRowType;
    }

    public void deserializeMessage(byte[] message, Collector<SeaTunnelRow> out, TablePath tablePath) {
        block30: {
            ObjectNode jsonNode;
            if (message == null || message.length == 0) {
                return;
            }
            try {
                jsonNode = this.convertBytes(message);
            }
            catch (RuntimeException e) {
                if (!this.ignoreParseErrors) {
                    throw e;
                }
                return;
            }
            try {
                if (this.database != null && !this.databasePattern.matcher(jsonNode.get(FIELD_DATABASE_TABLE).asText().split("\\.")[0]).matches()) {
                    return;
                }
                if (this.table != null && !this.tablePattern.matcher(jsonNode.get(FIELD_DATABASE_TABLE).asText().split("\\.")[1]).matches()) {
                    return;
                }
                String op = jsonNode.get(FIELD_TYPE).asText().trim();
                JsonNode tsNode = jsonNode.get(FIELD_TS);
                long ts = 0L;
                if (tsNode != null) {
                    String tsDateTime = tsNode.asText();
                    ts = DateTimeUtils.parse((String)tsDateTime).toEpochSecond(ZoneOffset.UTC) * 1000L;
                }
                switch (op) {
                    case "I": {
                        JsonNode dataInsert = jsonNode.get(DATA_AFTER);
                        SeaTunnelRow row = this.convertJsonNode(dataInsert);
                        if (tablePath != null) {
                            row.setTableId(tablePath.toString());
                        }
                        if (tsNode != null) {
                            MetadataUtil.setEventTime((SeaTunnelRow)row, (Long)ts);
                        }
                        out.collect((Object)row);
                        break;
                    }
                    case "U": {
                        JsonNode dataBefore = jsonNode.get(DATA_BEFORE);
                        if (dataBefore == null || dataBefore.isNull()) {
                            throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                        }
                        JsonNode dataAfter = jsonNode.get(DATA_AFTER);
                        SeaTunnelRow before = this.convertJsonNode(dataBefore);
                        SeaTunnelRow after = this.convertJsonNode(dataAfter);
                        before.setRowKind(RowKind.UPDATE_BEFORE);
                        if (tablePath != null) {
                            before.setTableId(tablePath.toString());
                        }
                        if (tsNode != null) {
                            MetadataUtil.setEventTime((SeaTunnelRow)before, (Long)ts);
                        }
                        out.collect((Object)before);
                        after.setRowKind(RowKind.UPDATE_AFTER);
                        if (tablePath != null) {
                            after.setTableId(tablePath.toString());
                        }
                        if (tsNode != null) {
                            MetadataUtil.setEventTime((SeaTunnelRow)after, (Long)ts);
                        }
                        out.collect((Object)after);
                        break;
                    }
                    case "D": {
                        JsonNode dataBeforeDel = jsonNode.get(DATA_BEFORE);
                        if (dataBeforeDel == null || dataBeforeDel.isNull()) {
                            throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                        }
                        SeaTunnelRow beforeDelete = this.convertJsonNode(dataBeforeDel);
                        if (beforeDelete == null) {
                            throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                        }
                        beforeDelete.setRowKind(RowKind.DELETE);
                        if (tablePath != null) {
                            beforeDelete.setTableId(tablePath.toString());
                        }
                        if (tsNode != null) {
                            MetadataUtil.setEventTime((SeaTunnelRow)beforeDelete, (Long)ts);
                        }
                        out.collect((Object)beforeDelete);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown operation type '%s'.", op));
                    }
                }
            }
            catch (RuntimeException e) {
                if (this.ignoreParseErrors) break block30;
                throw CommonError.jsonOperationError((String)FORMAT, (String)jsonNode.toString(), (Throwable)e);
            }
        }
    }

    private ObjectNode convertBytes(byte[] message) throws SeaTunnelRuntimeException {
        try {
            return (ObjectNode)this.jsonDeserializer.deserializeToJsonNode(message);
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)t);
        }
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) {
        TablePath tablePath = Optional.ofNullable(this.catalogTable).map(CatalogTable::getTablePath).orElse(null);
        this.deserializeMessage(message, out, tablePath);
    }

    private SeaTunnelRow convertJsonNode(JsonNode root) {
        return this.jsonDeserializer.convertToRowData(root);
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType physicalDataType) {
        return physicalDataType;
    }

    public static Builder builder(CatalogTable catalogTable) {
        return new Builder(catalogTable);
    }

    public static class Builder {
        private boolean ignoreParseErrors = false;
        private String database = null;
        private String table = null;
        private CatalogTable catalogTable;

        public Builder(CatalogTable catalogTable) {
            this.catalogTable = catalogTable;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public OggJsonDeserializationSchema build() {
            return new OggJsonDeserializationSchema(this.catalogTable, this.database, this.table, this.ignoreParseErrors);
        }
    }
}

