/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.canal;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.format.json.JsonSerializationSchema;
import org.apache.seatunnel.format.json.exception.SeaTunnelJsonFormatException;

public class CanalJsonSerializationSchema
implements SerializationSchema {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "Canal";
    private static final String OP_INSERT = "INSERT";
    private static final String OP_DELETE = "DELETE";
    private transient SeaTunnelRow reuse;
    private final JsonSerializationSchema jsonSerializer;

    public CanalJsonSerializationSchema(SeaTunnelRowType rowType) {
        this.jsonSerializer = new JsonSerializationSchema(CanalJsonSerializationSchema.createJsonRowType(rowType));
        this.reuse = new SeaTunnelRow(5);
    }

    public CanalJsonSerializationSchema(SeaTunnelRowType rowType, Charset charset) {
        this.jsonSerializer = new JsonSerializationSchema(CanalJsonSerializationSchema.createJsonRowType(rowType), charset);
        this.reuse = new SeaTunnelRow(5);
    }

    public byte[] serialize(SeaTunnelRow row) {
        try {
            String opType = this.rowKind2String(row.getRowKind());
            this.reuse.setField(0, (Object)new SeaTunnelRow[]{row});
            this.reuse.setField(1, (Object)opType);
            if (!StringUtils.isEmpty(row.getTableId())) {
                this.reuse.setField(2, (Object)TablePath.of((String)row.getTableId()).getDatabaseName());
                this.reuse.setField(3, (Object)TablePath.of((String)row.getTableId()).getTableName());
            }
            if (row.getOptions() != null && row.getOptions().containsKey(CommonOptions.EVENT_TIME.getName())) {
                this.reuse.setField(4, row.getOptions().get(CommonOptions.EVENT_TIME.getName()));
            }
            return this.jsonSerializer.serialize(this.reuse);
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)row.toString(), (Throwable)t);
        }
    }

    private String rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported operation %s for row kind.", rowKind));
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType databaseSchema) {
        return new SeaTunnelRowType(new String[]{"data", "type", "database", "table", "ts"}, new SeaTunnelDataType[]{new ArrayType(SeaTunnelRowType[].class, (SeaTunnelDataType)databaseSchema), BasicType.STRING_TYPE, BasicType.STRING_TYPE, BasicType.STRING_TYPE, BasicType.LONG_TYPE});
    }
}

