/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.bytes.ByteBufferInputStream;

class SingleBufferInputStream
extends ByteBufferInputStream {
    private final ByteBuffer buffer;
    private final long startPosition;
    private int mark = -1;

    SingleBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.startPosition = buffer.position();
    }

    @Override
    public long position() {
        return (long)this.buffer.position() - this.startPosition;
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            throw new EOFException();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int remaining = this.buffer.remaining();
        if (remaining <= 0) {
            return -1;
        }
        int bytesToRead = Math.min(this.buffer.remaining(), length);
        this.buffer.get(bytes, offset, bytesToRead);
        return bytesToRead;
    }

    @Override
    public long skip(long n) {
        if (n == 0L) {
            return 0L;
        }
        if (this.buffer.remaining() <= 0) {
            return -1L;
        }
        int bytesToSkip = (int)Math.min((long)this.buffer.remaining(), n);
        this.buffer.position(this.buffer.position() + bytesToSkip);
        return bytesToSkip;
    }

    @Override
    public int read(ByteBuffer out) {
        ByteBuffer copyBuffer;
        int bytesToCopy;
        if (this.buffer.remaining() <= out.remaining()) {
            bytesToCopy = this.buffer.remaining();
            copyBuffer = this.buffer;
        } else {
            bytesToCopy = out.remaining();
            copyBuffer = this.buffer.duplicate();
            copyBuffer.limit(this.buffer.position() + bytesToCopy);
            this.buffer.position(this.buffer.position() + bytesToCopy);
        }
        out.put(copyBuffer);
        out.flip();
        return bytesToCopy;
    }

    @Override
    public ByteBuffer slice(int length) throws EOFException {
        if (this.buffer.remaining() < length) {
            throw new EOFException();
        }
        ByteBuffer copy = this.buffer.duplicate();
        copy.limit(copy.position() + length);
        this.buffer.position(this.buffer.position() + length);
        return copy;
    }

    @Override
    public List<ByteBuffer> sliceBuffers(long length) throws EOFException {
        if (length == 0L) {
            return Collections.emptyList();
        }
        if (length > (long)this.buffer.remaining()) {
            throw new EOFException();
        }
        return Collections.singletonList(this.slice((int)length));
    }

    @Override
    public List<ByteBuffer> remainingBuffers() {
        if (this.buffer.remaining() <= 0) {
            return Collections.emptyList();
        }
        ByteBuffer remaining = this.buffer.duplicate();
        this.buffer.position(this.buffer.limit());
        return Collections.singletonList(remaining);
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.buffer.position();
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0) {
            throw new IOException("No mark defined");
        }
        this.buffer.position(this.mark);
        this.mark = -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }
}

