/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.ShouldNeverHappenException;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.bytes.MultiBufferInputStream;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.bytes.SingleBufferInputStream;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBufferInputStream delegate;

    public static ByteBufferInputStream wrap(ByteBuffer ... buffers) {
        if (buffers.length == 1) {
            return new SingleBufferInputStream(buffers[0]);
        }
        return new MultiBufferInputStream(Arrays.asList(buffers));
    }

    public static ByteBufferInputStream wrap(List<ByteBuffer> buffers) {
        if (buffers.size() == 1) {
            return new SingleBufferInputStream(buffers.get(0));
        }
        return new MultiBufferInputStream(buffers);
    }

    ByteBufferInputStream() {
        this.delegate = null;
    }

    @Deprecated
    public ByteBufferInputStream(ByteBuffer buffer) {
        this.delegate = ByteBufferInputStream.wrap(buffer);
    }

    @Deprecated
    public ByteBufferInputStream(ByteBuffer buffer, int offset, int count) {
        ByteBuffer temp = buffer.duplicate();
        temp.position(offset);
        ByteBuffer byteBuf = temp.slice();
        byteBuf.limit(count);
        this.delegate = ByteBufferInputStream.wrap(byteBuf);
    }

    @Deprecated
    public ByteBuffer toByteBuffer() {
        try {
            return this.slice(this.available());
        }
        catch (EOFException e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public long position() {
        return this.delegate.position();
    }

    public void skipFully(long n) throws IOException {
        long skipped = this.skip(n);
        if (skipped < n) {
            throw new EOFException("Not enough bytes to skip: " + skipped + " < " + n);
        }
    }

    public int read(ByteBuffer out) {
        return this.delegate.read(out);
    }

    public ByteBuffer slice(int length) throws EOFException {
        return this.delegate.slice(length);
    }

    public List<ByteBuffer> sliceBuffers(long length) throws EOFException {
        return this.delegate.sliceBuffers(length);
    }

    public ByteBufferInputStream sliceStream(long length) throws EOFException {
        return ByteBufferInputStream.wrap(this.sliceBuffers(length));
    }

    public List<ByteBuffer> remainingBuffers() {
        return this.delegate.remainingBuffers();
    }

    public ByteBufferInputStream remainingStream() {
        return ByteBufferInputStream.wrap(this.remainingBuffers());
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) {
        return this.delegate.skip(n);
    }

    @Override
    public int available() {
        return this.delegate.available();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

