/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.hdfs.source;

import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.hdfs.source.config.HdfsSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.source.BaseFileSource;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public abstract class BaseHdfsFileSource
extends BaseFileSource {
    public void prepare(Config pluginConfig) throws PrepareFailException {
        block13: {
            block12: {
                CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{HdfsSourceConfig.FILE_PATH.key(), HdfsSourceConfig.FILE_FORMAT_TYPE.key(), HdfsSourceConfig.DEFAULT_FS.key()});
                if (!result.isSuccess()) {
                    throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, result.getMsg()));
                }
                this.readStrategy = ReadStrategyFactory.of((String)pluginConfig.getString(HdfsSourceConfig.FILE_FORMAT_TYPE.key()));
                this.readStrategy.setPluginConfig(pluginConfig);
                String path = pluginConfig.getString(HdfsSourceConfig.FILE_PATH.key());
                this.hadoopConf = new HadoopConf(pluginConfig.getString(HdfsSourceConfig.DEFAULT_FS.key()));
                if (pluginConfig.hasPath(HdfsSourceConfig.HDFS_SITE_PATH.key())) {
                    this.hadoopConf.setHdfsSitePath(pluginConfig.getString(HdfsSourceConfig.HDFS_SITE_PATH.key()));
                }
                if (pluginConfig.hasPath(HdfsSourceConfig.KERBEROS_PRINCIPAL.key())) {
                    this.hadoopConf.setKerberosPrincipal(pluginConfig.getString(HdfsSourceConfig.KERBEROS_PRINCIPAL.key()));
                }
                if (pluginConfig.hasPath(HdfsSourceConfig.KERBEROS_KEYTAB_PATH.key())) {
                    this.hadoopConf.setKerberosKeytabPath(pluginConfig.getString(HdfsSourceConfig.KERBEROS_KEYTAB_PATH.key()));
                }
                try {
                    this.filePaths = this.readStrategy.getFileNamesByPath(this.hadoopConf, path);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Get file list from this path [%s] failed", path);
                    throw new FileConnectorException((SeaTunnelErrorCode)FileConnectorErrorCode.FILE_LIST_GET_FAILED, errorMsg, (Throwable)e);
                }
                FileFormat fileFormat = FileFormat.valueOf((String)pluginConfig.getString(HdfsSourceConfig.FILE_FORMAT_TYPE.key()).toUpperCase());
                if (!pluginConfig.hasPath(CatalogTableUtil.SCHEMA.key())) break block12;
                switch (fileFormat) {
                    case CSV: 
                    case TEXT: 
                    case JSON: 
                    case EXCEL: {
                        SeaTunnelRowType userDefinedSchema = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
                        this.readStrategy.setSeaTunnelRowTypeInfo(userDefinedSchema);
                        this.rowType = this.readStrategy.getActualSeaTunnelRowTypeInfo();
                        break block13;
                    }
                    case ORC: 
                    case PARQUET: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "SeaTunnel does not support user-defined schema for [parquet, orc] files");
                    }
                    default: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, "SeaTunnel does not supported this file format");
                    }
                }
            }
            try {
                this.rowType = this.readStrategy.getSeaTunnelRowTypeInfo(this.hadoopConf, (String)this.filePaths.get(0));
            }
            catch (FileConnectorException e) {
                String errorMsg = String.format("Get table schema from file [%s] failed", this.filePaths.get(0));
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.TABLE_SCHEMA_GET_FAILED, errorMsg, (Throwable)e);
            }
        }
    }
}

