/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.hdfs.source;

import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.connectors.seatunnel.common.schema.SeaTunnelSchema;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FilePluginException;
import org.apache.seatunnel.connectors.seatunnel.file.source.BaseFileSource;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public abstract class BaseHdfsFileSource
extends BaseFileSource {
    public void prepare(Config pluginConfig) throws PrepareFailException {
        CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{"path", "type", "fs.defaultFS"});
        if (!result.isSuccess()) {
            throw new PrepareFailException(this.getPluginName(), PluginType.SOURCE, result.getMsg());
        }
        this.readStrategy = ReadStrategyFactory.of((String)pluginConfig.getString("type"));
        String path = pluginConfig.getString("path");
        this.hadoopConf = new HadoopConf(pluginConfig.getString("fs.defaultFS"));
        try {
            this.filePaths = this.readStrategy.getFileNamesByPath(this.hadoopConf, path);
        }
        catch (IOException e) {
            throw new PrepareFailException(this.getPluginName(), PluginType.SOURCE, "Check file path fail.");
        }
        if (pluginConfig.hasPath("schema")) {
            Config schemaConfig = pluginConfig.getConfig("schema");
            this.rowType = SeaTunnelSchema.buildWithConfig((Config)schemaConfig).getSeaTunnelRowType();
            this.readStrategy.setSeaTunnelRowTypeInfo(this.rowType);
        } else {
            try {
                this.rowType = this.readStrategy.getSeaTunnelRowTypeInfo(this.hadoopConf, (String)this.filePaths.get(0));
            }
            catch (FilePluginException e) {
                throw new PrepareFailException(this.getPluginName(), PluginType.SOURCE, "Read file schema error.", (Throwable)e);
            }
        }
    }
}

