/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlite;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqliteTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(SqliteTypeMapper.class);
    private static final String SQLITE_UNKNOWN = "UNKNOWN";
    private static final String SQLITE_BIT = "BIT";
    private static final String SQLITE_BOOLEAN = "BOOLEAN";
    private static final String SQLITE_TINYINT = "TINYINT";
    private static final String SQLITE_TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final String SQLITE_SMALLINT = "SMALLINT";
    private static final String SQLITE_SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    private static final String SQLITE_MEDIUMINT = "MEDIUMINT";
    private static final String SQLITE_MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    private static final String SQLITE_INT = "INT";
    private static final String SQLITE_INT_UNSIGNED = "INT UNSIGNED";
    private static final String SQLITE_INTEGER = "INTEGER";
    private static final String SQLITE_INTEGER_UNSIGNED = "INTEGER UNSIGNED";
    private static final String SQLITE_BIGINT = "BIGINT";
    private static final String SQLITE_BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    private static final String SQLITE_DECIMAL = "DECIMAL";
    private static final String SQLITE_DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    private static final String SQLITE_FLOAT = "FLOAT";
    private static final String SQLITE_FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    private static final String SQLITE_DOUBLE = "DOUBLE";
    private static final String SQLITE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String SQLITE_DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    private static final String SQLITE_NUMERIC = "NUMERIC";
    private static final String SQLITE_REAL = "REAL";
    private static final String SQLITE_CHAR = "CHAR";
    private static final String SQLITE_CHARACTER = "CHARACTER";
    private static final String SQLITE_VARYING_CHARACTER = "VARYING_CHARACTER";
    private static final String SQLITE_NATIVE_CHARACTER = "NATIVE_CHARACTER";
    private static final String SQLITE_NCHAR = "NCHAR";
    private static final String SQLITE_VARCHAR = "VARCHAR";
    private static final String SQLITE_LONGVARCHAR = "LONGVARCHAR";
    private static final String SQLITE_LONGNVARCHAR = "LONGNVARCHAR";
    private static final String SQLITE_NVARCHAR = "NVARCHAR";
    private static final String SQLITE_TINYTEXT = "TINYTEXT";
    private static final String SQLITE_MEDIUMTEXT = "MEDIUMTEXT";
    private static final String SQLITE_TEXT = "TEXT";
    private static final String SQLITE_LONGTEXT = "LONGTEXT";
    private static final String SQLITE_JSON = "JSON";
    private static final String SQLITE_CLOB = "CLOB";
    private static final String SQLITE_DATE = "DATE";
    private static final String SQLITE_DATETIME = "DATETIME";
    private static final String SQLITE_TIME = "TIME";
    private static final String SQLITE_TIMESTAMP = "TIMESTAMP";
    private static final String SQLITE_TINYBLOB = "TINYBLOB";
    private static final String SQLITE_MEDIUMBLOB = "MEDIUMBLOB";
    private static final String SQLITE_BLOB = "BLOB";
    private static final String SQLITE_LONGBLOB = "LONGBLOB";
    private static final String SQLITE_BINARY = "BINARY";
    private static final String SQLITE_VARBINARY = "VARBINARY";
    private static final String SQLITE_LONGVARBINARY = "LONGVARBINARY";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnTypeName;
        switch (columnTypeName = metadata.getColumnTypeName(colIndex).toUpperCase().trim()) {
            case "BIT": 
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "TINYINT": 
            case "TINYINT UNSIGNED": 
            case "SMALLINT": 
            case "SMALLINT UNSIGNED": {
                return BasicType.SHORT_TYPE;
            }
            case "MEDIUMINT": 
            case "MEDIUMINT UNSIGNED": 
            case "INT": 
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "INT UNSIGNED": 
            case "INTEGER UNSIGNED": 
            case "BIGINT": 
            case "BIGINT UNSIGNED": 
            case "NUMERIC": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": 
            case "DECIMAL UNSIGNED": 
            case "DOUBLE": 
            case "DOUBLE PRECISION": 
            case "REAL": {
                return BasicType.DOUBLE_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "FLOAT UNSIGNED": {
                log.warn("{} will probably cause value overflow.", (Object)SQLITE_FLOAT_UNSIGNED);
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE UNSIGNED": {
                log.warn("{} will probably cause value overflow.", (Object)SQLITE_DOUBLE_UNSIGNED);
                return BasicType.DOUBLE_TYPE;
            }
            case "CHARACTER": 
            case "VARYING_CHARACTER": 
            case "NATIVE_CHARACTER": 
            case "NVARCHAR": 
            case "NCHAR": 
            case "LONGNVARCHAR": 
            case "LONGVARCHAR": 
            case "CLOB": 
            case "CHAR": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "TEXT": 
            case "VARCHAR": 
            case "JSON": 
            case "LONGTEXT": 
            case "DATE": 
            case "TIME": 
            case "DATETIME": 
            case "TIMESTAMP": {
                return BasicType.STRING_TYPE;
            }
            case "TINYBLOB": 
            case "MEDIUMBLOB": 
            case "BLOB": 
            case "LONGBLOB": 
            case "VARBINARY": 
            case "BINARY": 
            case "LONGVARBINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw new UnsupportedOperationException(String.format("Doesn't support SQLite type '%s' on column '%s'  yet.", columnTypeName, jdbcColumnName));
    }
}

