/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.snowflake;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeTypeMapper.class);
    private static final String SNOWFLAKE_NUMBER = "NUMBER";
    private static final String SNOWFLAKE_DECIMAL = "DECIMAL";
    private static final String SNOWFLAKE_NUMERIC = "NUMERIC";
    private static final String SNOWFLAKE_INT = "INT";
    private static final String SNOWFLAKE_INTEGER = "INTEGER";
    private static final String SNOWFLAKE_BIGINT = "BIGINT";
    private static final String SNOWFLAKE_SMALLINT = "SMALLINT";
    private static final String SNOWFLAKE_TINYINT = "TINYINT";
    private static final String SNOWFLAKE_BYTEINT = "BYTEINT";
    private static final String SNOWFLAKE_FLOAT = "FLOAT";
    private static final String SNOWFLAKE_FLOAT4 = "FLOAT4";
    private static final String SNOWFLAKE_FLOAT8 = "FLOAT8";
    private static final String SNOWFLAKE_DOUBLE = "DOUBLE";
    private static final String SNOWFLAKE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String SNOWFLAKE_REAL = "REAL";
    private static final String SNOWFLAKE_VARCHAR = "VARCHAR";
    private static final String SNOWFLAKE_CHAR = "CHAR";
    private static final String SNOWFLAKE_CHARACTER = "CHARACTER";
    private static final String SNOWFLAKE_STRING = "STRING";
    private static final String SNOWFLAKE_TEXT = "TEXT";
    private static final String SNOWFLAKE_BINARY = "BINARY";
    private static final String SNOWFLAKE_VARBINARY = "VARBINARY";
    private static final String SNOWFLAKE_BOOLEAN = "BOOLEAN";
    private static final String SNOWFLAKE_DATE = "DATE";
    private static final String SNOWFLAKE_DATE_TIME = "DATE_TIME";
    private static final String SNOWFLAKE_TIME = "TIME";
    private static final String SNOWFLAKE_TIMESTAMP = "TIMESTAMP";
    private static final String SNOWFLAKE_TIMESTAMP_LTZ = "TIMESTAMPLTZ";
    private static final String SNOWFLAKE_TIMESTAMP_NTZ = "TIMESTAMPNTZ";
    private static final String SNOWFLAKE_TIMESTAMP_TZ = "TIMESTAMPTZ";
    private static final String SNOWFLAKE_GEOGRAPHY = "GEOGRAPHY";
    private static final String SNOWFLAKE_GEOMETRY = "GEOMETRY";
    private static final String SNOWFLAKE_VARIANT = "VARIANT";
    private static final String SNOWFLAKE_OBJECT = "OBJECT";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String snowflakeType = metadata.getColumnTypeName(colIndex).toUpperCase();
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (snowflakeType) {
            case "SMALLINT": 
            case "TINYINT": 
            case "BYTEINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INTEGER": 
            case "INT": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": 
            case "NUMERIC": 
            case "NUMBER": {
                return new DecimalType(precision, scale);
            }
            case "REAL": 
            case "FLOAT4": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": 
            case "DOUBLE PRECISION": 
            case "FLOAT8": 
            case "FLOAT": {
                return BasicType.DOUBLE_TYPE;
            }
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "CHAR": 
            case "CHARACTER": 
            case "VARCHAR": 
            case "STRING": 
            case "TEXT": 
            case "VARIANT": 
            case "OBJECT": {
                return BasicType.STRING_TYPE;
            }
            case "GEOGRAPHY": 
            case "GEOMETRY": {
                int geoMetaType = metadata.getColumnType(colIndex);
                switch (geoMetaType) {
                    case -2: {
                        return PrimitiveByteArrayType.INSTANCE;
                    }
                }
                return BasicType.STRING_TYPE;
            }
            case "BINARY": 
            case "VARBINARY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "DATE_TIME": 
            case "TIMESTAMP": 
            case "TIMESTAMPLTZ": 
            case "TIMESTAMPNTZ": 
            case "TIMESTAMPTZ": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw new UnsupportedOperationException(String.format("Doesn't support SNOWFLAKE type '%s' on column '%s'  yet.", snowflakeType, jdbcColumnName));
    }
}

