/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcInputFormat
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected static final Logger LOG = LoggerFactory.getLogger(JdbcInputFormat.class);
    protected JdbcConnectionProvider connectionProvider;
    protected JdbcRowConverter jdbcRowConverter;
    protected String queryTemplate;
    protected SeaTunnelRowType typeInfo;
    protected int fetchSize;
    protected Boolean autoCommit;
    protected transient PreparedStatement statement;
    protected transient ResultSet resultSet;
    protected boolean hasNext;
    protected JdbcDialect jdbcDialect;

    public JdbcInputFormat(JdbcConnectionProvider connectionProvider, JdbcDialect jdbcDialect, SeaTunnelRowType typeInfo, String queryTemplate, int fetchSize, Boolean autoCommit) {
        this.connectionProvider = connectionProvider;
        this.jdbcRowConverter = jdbcDialect.getRowConverter();
        this.typeInfo = typeInfo;
        this.queryTemplate = queryTemplate;
        this.fetchSize = fetchSize;
        this.autoCommit = autoCommit;
        this.jdbcDialect = jdbcDialect;
    }

    public void openInputFormat() {
        try {
            Connection dbConn = this.connectionProvider.getOrEstablishConnection();
            if (this.autoCommit != null) {
                dbConn.setAutoCommit(this.autoCommit);
            }
            this.statement = this.jdbcDialect.creatPreparedStatement(dbConn, this.queryTemplate, this.fetchSize);
        }
        catch (SQLException se) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.CONNECT_DATABASE_FAILED, "open() failed." + se.getMessage(), se);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.CLASS_NOT_FOUND, "JDBC-Class not found. - " + cnfe.getMessage(), cnfe);
        }
    }

    public void closeInputFormat() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException se) {
            LOG.info("Inputformat Statement couldn't be closed - " + se.getMessage());
        }
        finally {
            this.statement = null;
        }
        this.connectionProvider.closeConnection();
    }

    public void open(JdbcSourceSplit inputSplit) throws IOException {
        try {
            Object[] parameterValues;
            if (!this.connectionProvider.isConnectionValid()) {
                this.openInputFormat();
            }
            if ((parameterValues = inputSplit.getParameterValues()) != null) {
                for (int i = 0; i < parameterValues.length; ++i) {
                    Object param = parameterValues[i];
                    if (param instanceof String) {
                        this.statement.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Long) {
                        this.statement.setLong(i + 1, (Long)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        this.statement.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Double) {
                        this.statement.setDouble(i + 1, (Double)param);
                        continue;
                    }
                    if (param instanceof Boolean) {
                        this.statement.setBoolean(i + 1, (Boolean)param);
                        continue;
                    }
                    if (param instanceof Float) {
                        this.statement.setFloat(i + 1, ((Float)param).floatValue());
                        continue;
                    }
                    if (param instanceof BigDecimal) {
                        this.statement.setBigDecimal(i + 1, (BigDecimal)param);
                        continue;
                    }
                    if (param instanceof Byte) {
                        this.statement.setByte(i + 1, (Byte)param);
                        continue;
                    }
                    if (param instanceof Short) {
                        this.statement.setShort(i + 1, (Short)param);
                        continue;
                    }
                    if (param instanceof Date) {
                        this.statement.setDate(i + 1, (Date)param);
                        continue;
                    }
                    if (param instanceof Time) {
                        this.statement.setTime(i + 1, (Time)param);
                        continue;
                    }
                    if (param instanceof Timestamp) {
                        this.statement.setTimestamp(i + 1, (Timestamp)param);
                        continue;
                    }
                    if (param instanceof Array) {
                        this.statement.setArray(i + 1, (Array)param);
                        continue;
                    }
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, "open() failed. Parameter " + i + " of type " + param.getClass() + " is not handled (yet).");
                }
            }
            this.resultSet = this.statement.executeQuery();
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException se) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.SQL_OPERATION_FAILED, "open() failed." + se.getMessage(), se);
        }
    }

    public void close() throws IOException {
        if (this.resultSet == null) {
            return;
        }
        try {
            this.resultSet.close();
        }
        catch (SQLException se) {
            LOG.info("Inputformat ResultSet couldn't be closed - " + se.getMessage());
        }
    }

    public boolean reachedEnd() {
        return !this.hasNext;
    }

    public SeaTunnelRow nextRecord() {
        try {
            if (!this.hasNext) {
                return null;
            }
            SeaTunnelRow seaTunnelRow = this.jdbcRowConverter.toInternal(this.resultSet, this.typeInfo);
            this.hasNext = this.resultSet.next();
            return seaTunnelRow;
        }
        catch (SQLException se) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.SQL_OPERATION_FAILED, "Couldn't read data - " + se.getMessage(), se);
        }
        catch (NullPointerException npe) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.SQL_OPERATION_FAILED, "Couldn't access resultSet", npe);
        }
    }
}

