/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.redshift;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertException;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;

@AutoService(value={DataTypeConvertor.class})
public class RedshiftDataTypeConvertor
implements DataTypeConvertor<String> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;
    private static final String REDSHIFT_SMALLINT = "smallint";
    private static final String REDSHIFT_INT2 = "int2";
    private static final String REDSHIFT_INTEGER = "integer";
    private static final String REDSHIFT_INT = "int";
    private static final String REDSHIFT_INT4 = "int4";
    private static final String REDSHIFT_BIGINT = "bigint";
    private static final String REDSHIFT_INT8 = "int8";
    private static final String REDSHIFT_DECIMAL = "decimal";
    private static final String REDSHIFT_NUMERIC = "numeric";
    private static final String REDSHIFT_REAL = "real";
    private static final String REDSHIFT_FLOAT4 = "float4";
    private static final String REDSHIFT_DOUBLE_PRECISION = "double precision";
    private static final String REDSHIFT_FLOAT8 = "float8";
    private static final String REDSHIFT_FLOAT = "float";
    private static final String REDSHIFT_BOOLEAN = "boolean";
    private static final String REDSHIFT_BOOL = "bool";
    private static final String REDSHIFT_CHAR = "char";
    private static final String REDSHIFT_CHARACTER = "character";
    private static final String REDSHIFT_NCHAR = "nchar";
    private static final String REDSHIFT_BPCHAR = "bpchar";
    private static final String REDSHIFT_VARCHAR = "varchar";
    private static final String REDSHIFT_CHARACTER_VARYING = "character varying";
    private static final String REDSHIFT_NVARCHAR = "nvarchar";
    private static final String REDSHIFT_TEXT = "text";
    private static final String REDSHIFT_DATE = "date";
    private static final String REDSHIFT_GEOMETRY = "geometry";
    private static final String REDSHIFT_OID = "oid";
    private static final String REDSHIFT_SUPER = "super";
    private static final String REDSHIFT_TIME = "time";
    private static final String REDSHIFT_TIME_WITH_TIME_ZONE = "time with time zone";
    private static final String REDSHIFT_TIMETZ = "timetz";
    private static final String REDSHIFT_TIMESTAMP = "timestamp";
    private static final String REDSHIFT_TIMESTAMP_WITH_OUT_TIME_ZONE = "timestamp without time zone";
    private static final String REDSHIFT_TIMESTAMPTZ = "timestamptz";

    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType) {
        return this.toSeaTunnelType(connectorDataType, Collections.emptyMap());
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Preconditions.checkNotNull(connectorDataType, "redshiftType cannot be null");
        switch (connectorDataType) {
            case "smallint": 
            case "int2": {
                return BasicType.SHORT_TYPE;
            }
            case "integer": 
            case "int": 
            case "int4": {
                return BasicType.INT_TYPE;
            }
            case "bigint": 
            case "int8": 
            case "oid": {
                return BasicType.LONG_TYPE;
            }
            case "decimal": 
            case "numeric": {
                Integer precision = MapUtils.getInteger(dataTypeProperties, (Object)PRECISION, (Integer)DEFAULT_PRECISION);
                Integer scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                return new DecimalType(precision.intValue(), scale.intValue());
            }
            case "real": 
            case "float4": {
                return BasicType.FLOAT_TYPE;
            }
            case "double precision": 
            case "float8": 
            case "float": {
                return BasicType.DOUBLE_TYPE;
            }
            case "boolean": 
            case "bool": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "char": 
            case "character": 
            case "nchar": 
            case "bpchar": 
            case "varchar": 
            case "character varying": 
            case "nvarchar": 
            case "text": 
            case "super": {
                return BasicType.STRING_TYPE;
            }
            case "date": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "geometry": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "time": 
            case "time with time zone": 
            case "timetz": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "timestamp": 
            case "timestamp without time zone": 
            case "timestamptz": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support REDSHIFT type '%s''  yet.", connectorDataType));
    }

    public String toConnectorType(SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Preconditions.checkNotNull(seaTunnelDataType, "seaTunnelDataType cannot be null");
        SqlType sqlType = seaTunnelDataType.getSqlType();
        switch (sqlType) {
            case TINYINT: 
            case SMALLINT: {
                return REDSHIFT_SMALLINT;
            }
            case INT: {
                return REDSHIFT_INTEGER;
            }
            case BIGINT: {
                return REDSHIFT_BIGINT;
            }
            case DECIMAL: {
                return REDSHIFT_DECIMAL;
            }
            case FLOAT: {
                return REDSHIFT_FLOAT4;
            }
            case DOUBLE: {
                return REDSHIFT_DOUBLE_PRECISION;
            }
            case BOOLEAN: {
                return REDSHIFT_BOOLEAN;
            }
            case STRING: {
                return REDSHIFT_TEXT;
            }
            case DATE: {
                return REDSHIFT_DATE;
            }
            case BYTES: {
                return REDSHIFT_GEOMETRY;
            }
            case TIME: {
                return REDSHIFT_TIME;
            }
            case TIMESTAMP: {
                return REDSHIFT_TIMESTAMP;
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support SeaTunnel type '%s''  yet.", seaTunnelDataType));
    }

    public String getIdentity() {
        return "REDSHIFT";
    }
}

