/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.SupportMultipleTable;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.type.MultipleRowType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.option.JdbcSourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.SourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.option.StopMode;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.SqlServerIncrementalSource;
import org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.source.source.SqlServerSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;

@AutoService(value={Factory.class})
public class SqlServerIncrementalSourceFactory
implements TableSourceFactory,
SupportMultipleTable {
    public String factoryIdentifier() {
        return "SqlServer-CDC";
    }

    public OptionRule optionRule() {
        return JdbcSourceOptions.getBaseRule().required(new Option[]{JdbcSourceOptions.USERNAME, JdbcSourceOptions.PASSWORD, CatalogOptions.TABLE_NAMES, JdbcCatalogOptions.BASE_URL}).optional(new Option[]{JdbcSourceOptions.DATABASE_NAMES, JdbcSourceOptions.SERVER_TIME_ZONE, JdbcSourceOptions.CONNECT_TIMEOUT_MS, JdbcSourceOptions.CONNECT_MAX_RETRIES, JdbcSourceOptions.CONNECTION_POOL_SIZE}).optional(new Option[]{SqlServerSourceOptions.STARTUP_MODE, SqlServerSourceOptions.STOP_MODE}).conditional(SqlServerSourceOptions.STARTUP_MODE, (Object)StartupMode.SPECIFIC, new Option[]{SourceOptions.STARTUP_SPECIFIC_OFFSET_POS}).conditional(SqlServerSourceOptions.STOP_MODE, (Object)StopMode.SPECIFIC, new Option[]{SourceOptions.STOP_SPECIFIC_OFFSET_POS}).conditional(SqlServerSourceOptions.STARTUP_MODE, (Object)StartupMode.TIMESTAMP, new Option[]{SourceOptions.STARTUP_TIMESTAMP}).conditional(SqlServerSourceOptions.STOP_MODE, (Object)StopMode.TIMESTAMP, new Option[]{SourceOptions.STOP_TIMESTAMP}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return SqlServerIncrementalSource.class;
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableFactoryContext context) {
        return () -> {
            SeaTunnelRowType dataType;
            if (context.getCatalogTables().size() == 1) {
                dataType = ((CatalogTable)context.getCatalogTables().get(0)).getTableSchema().toPhysicalRowDataType();
            } else {
                HashMap<String, SeaTunnelRowType> rowTypeMap = new HashMap<String, SeaTunnelRowType>();
                for (CatalogTable catalogTable : context.getCatalogTables()) {
                    String tableId = catalogTable.getTableId().toTablePath().toString();
                    rowTypeMap.put(tableId, catalogTable.getTableSchema().toPhysicalRowDataType());
                }
                dataType = new MultipleRowType(rowTypeMap);
            }
            return new SqlServerIncrementalSource(context.getOptions(), (SeaTunnelDataType<SeaTunnelRow>)dataType);
        };
    }

    public SupportMultipleTable.Result applyTables(TableFactoryContext context) {
        return SupportMultipleTable.Result.of((List)context.getCatalogTables(), Collections.emptyList());
    }
}

