/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.enumerator;

import io.debezium.relational.TableId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.source.enumerator.state.PendingSplitsState;
import org.apache.seatunnel.connectors.cdc.base.source.event.SnapshotSplitWatermark;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;

public interface SplitAssigner {
    public void open();

    public Optional<SourceSplitBase> getNext();

    public boolean waitingForCompletedSplits();

    public void onCompletedSplits(List<SnapshotSplitWatermark> var1);

    public void addSplits(Collection<SourceSplitBase> var1);

    public PendingSplitsState snapshotState(long var1);

    public void notifyCheckpointComplete(long var1);

    default public void close() {
    }

    public static final class Context<C extends SourceConfig> {
        private final C sourceConfig;
        private final Set<TableId> capturedTables;
        private final Map<String, SnapshotSplit> assignedSnapshotSplit;
        private final Map<String, Offset> splitCompletedOffsets;

        public Context(C sourceConfig, Set<TableId> capturedTables, Map<String, SnapshotSplit> assignedSnapshotSplit, Map<String, Offset> splitCompletedOffsets) {
            this.sourceConfig = sourceConfig;
            this.capturedTables = capturedTables;
            this.assignedSnapshotSplit = assignedSnapshotSplit;
            this.splitCompletedOffsets = splitCompletedOffsets;
        }

        public C getSourceConfig() {
            return this.sourceConfig;
        }

        public Set<TableId> getCapturedTables() {
            return this.capturedTables;
        }

        public Map<String, SnapshotSplit> getAssignedSnapshotSplit() {
            return this.assignedSnapshotSplit;
        }

        public Map<String, Offset> getSplitCompletedOffsets() {
            return this.splitCompletedOffsets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            C this$sourceConfig = this.getSourceConfig();
            C other$sourceConfig = other.getSourceConfig();
            if (this$sourceConfig == null ? other$sourceConfig != null : !this$sourceConfig.equals(other$sourceConfig)) {
                return false;
            }
            Set<TableId> this$capturedTables = this.getCapturedTables();
            Set<TableId> other$capturedTables = other.getCapturedTables();
            if (this$capturedTables == null ? other$capturedTables != null : !((Object)this$capturedTables).equals(other$capturedTables)) {
                return false;
            }
            Map<String, SnapshotSplit> this$assignedSnapshotSplit = this.getAssignedSnapshotSplit();
            Map<String, SnapshotSplit> other$assignedSnapshotSplit = other.getAssignedSnapshotSplit();
            if (this$assignedSnapshotSplit == null ? other$assignedSnapshotSplit != null : !((Object)this$assignedSnapshotSplit).equals(other$assignedSnapshotSplit)) {
                return false;
            }
            Map<String, Offset> this$splitCompletedOffsets = this.getSplitCompletedOffsets();
            Map<String, Offset> other$splitCompletedOffsets = other.getSplitCompletedOffsets();
            return !(this$splitCompletedOffsets == null ? other$splitCompletedOffsets != null : !((Object)this$splitCompletedOffsets).equals(other$splitCompletedOffsets));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            C $sourceConfig = this.getSourceConfig();
            result = result * 59 + ($sourceConfig == null ? 43 : $sourceConfig.hashCode());
            Set<TableId> $capturedTables = this.getCapturedTables();
            result = result * 59 + ($capturedTables == null ? 43 : ((Object)$capturedTables).hashCode());
            Map<String, SnapshotSplit> $assignedSnapshotSplit = this.getAssignedSnapshotSplit();
            result = result * 59 + ($assignedSnapshotSplit == null ? 43 : ((Object)$assignedSnapshotSplit).hashCode());
            Map<String, Offset> $splitCompletedOffsets = this.getSplitCompletedOffsets();
            result = result * 59 + ($splitCompletedOffsets == null ? 43 : ((Object)$splitCompletedOffsets).hashCode());
            return result;
        }

        public String toString() {
            return "SplitAssigner.Context(sourceConfig=" + this.getSourceConfig() + ", capturedTables=" + this.getCapturedTables() + ", assignedSnapshotSplit=" + this.getAssignedSnapshotSplit() + ", splitCompletedOffsets=" + this.getSplitCompletedOffsets() + ")";
        }
    }
}

