/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.relational;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.ChangeEventCreator;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkEvent;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkKind;

public class JdbcSourceEventDispatcher
extends EventDispatcher<TableId> {
    private final ChangeEventQueue<DataChangeEvent> queue;
    private final String topic;

    public JdbcSourceEventDispatcher(CommonConnectorConfig connectorConfig, TopicSelector<TableId> topicSelector, DatabaseSchema<TableId> schema, ChangeEventQueue<DataChangeEvent> queue, DataCollectionFilters.DataCollectionFilter<TableId> filter, ChangeEventCreator changeEventCreator, EventMetadataProvider metadataProvider, SchemaNameAdjuster schemaNameAdjuster) {
        super(connectorConfig, topicSelector, schema, queue, filter, changeEventCreator, metadataProvider, schemaNameAdjuster);
        this.queue = queue;
        this.topic = topicSelector.getPrimaryTopic();
    }

    public ChangeEventQueue<DataChangeEvent> getQueue() {
        return this.queue;
    }

    public void dispatchWatermarkEvent(Map<String, ?> sourcePartition, SourceSplitBase sourceSplit, Offset watermark, WatermarkKind watermarkKind) throws InterruptedException {
        SourceRecord sourceRecord = WatermarkEvent.create(sourcePartition, this.topic, sourceSplit.splitId(), watermarkKind, watermark);
        this.queue.enqueue(new DataChangeEvent(sourceRecord));
    }
}

