/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.jdbc.JdbcValueConverters;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;

public class SpecialValueDecimal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    public static SpecialValueDecimal ZERO = new SpecialValueDecimal(BigDecimal.ZERO);
    public static SpecialValueDecimal NOT_A_NUMBER = new SpecialValueDecimal(SpecialValue.NAN);
    public static SpecialValueDecimal POSITIVE_INF = new SpecialValueDecimal(SpecialValue.POSITIVE_INFINITY);
    public static SpecialValueDecimal NEGATIVE_INF = new SpecialValueDecimal(SpecialValue.NEGATIVE_INFINITY);
    private final BigDecimal decimalValue;
    private final SpecialValue specialValue;

    public SpecialValueDecimal(BigDecimal value) {
        this.decimalValue = value;
        this.specialValue = null;
    }

    private SpecialValueDecimal(SpecialValue specialValue) {
        this.specialValue = specialValue;
        this.decimalValue = null;
    }

    public Optional<BigDecimal> getDecimalValue() {
        return Optional.ofNullable(this.decimalValue);
    }

    public static SpecialValueDecimal valueOf(String decimal) {
        return new SpecialValueDecimal(new BigDecimal(decimal));
    }

    public double toDouble() {
        if (this.specialValue != null) {
            switch (this.specialValue) {
                case NAN: {
                    return Double.NaN;
                }
                case POSITIVE_INFINITY: {
                    return Double.POSITIVE_INFINITY;
                }
                case NEGATIVE_INFINITY: {
                    return Double.NEGATIVE_INFINITY;
                }
            }
        }
        return this.decimalValue.doubleValue();
    }

    public String toString() {
        return this.decimalValue != null ? this.decimalValue.toString() : this.specialValue.name();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.decimalValue == null ? 0 : this.decimalValue.hashCode());
        result = 31 * result + (this.specialValue == null ? 0 : this.specialValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecialValueDecimal other = (SpecialValueDecimal)obj;
        if (this.decimalValue == null ? other.decimalValue != null : !this.decimalValue.equals(other.decimalValue)) {
            return false;
        }
        return this.specialValue == other.specialValue;
    }

    public static SchemaBuilder builder(JdbcValueConverters.DecimalMode mode, int precision, int scale) {
        switch (mode) {
            case DOUBLE: {
                return SchemaBuilder.float64();
            }
            case PRECISE: {
                return Decimal.builder(scale).parameter(PRECISION_PARAMETER_KEY, String.valueOf(precision));
            }
            case STRING: {
                return SchemaBuilder.string();
            }
        }
        throw new IllegalArgumentException("Unknown decimalMode");
    }

    public static Object fromLogical(SpecialValueDecimal value, JdbcValueConverters.DecimalMode mode, String columnName) {
        if (value.getDecimalValue().isPresent()) {
            switch (mode) {
                case DOUBLE: {
                    return value.getDecimalValue().get().doubleValue();
                }
                case PRECISE: {
                    return value.getDecimalValue().get();
                }
                case STRING: {
                    return value.getDecimalValue().get().toString();
                }
            }
            throw new IllegalArgumentException("Unknown decimalMode");
        }
        switch (mode) {
            case STRING: {
                return value.toString();
            }
            case DOUBLE: {
                return value.toDouble();
            }
        }
        throw new ConnectException("Got a special value (NaN/Infinity) for Decimal type in column " + columnName + " but current mode does not handle it. If you need to support it then set decimal handling mode to 'string'.");
    }

    private static enum SpecialValue {
        NAN,
        POSITIVE_INFINITY,
        NEGATIVE_INFINITY;

    }
}

