/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SourceTimestampMode;
import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDefaultValueConverter;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.data.Envelope;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnection
extends JdbcConnection {
    public static final String SERVER_TIMEZONE_PROP_NAME = "server.timezone";
    public static final String INSTANCE_NAME = "instance";
    private static final String GET_DATABASE_NAME = "SELECT db_name()";
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnection.class);
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String GET_MAX_LSN = "SELECT sys.fn_cdc_get_max_lsn()";
    private static final String GET_MAX_TRANSACTION_LSN = "SELECT MAX(start_lsn) FROM cdc.lsn_time_mapping WHERE tran_id <> 0x00";
    private static final String GET_NTH_TRANSACTION_LSN_FROM_BEGINNING = "SELECT MAX(start_lsn) FROM (SELECT TOP (?) start_lsn FROM cdc.lsn_time_mapping WHERE tran_id <> 0x00 ORDER BY start_lsn) as next_lsns";
    private static final String GET_NTH_TRANSACTION_LSN_FROM_LAST = "SELECT MAX(start_lsn) FROM (SELECT TOP (? + 1) start_lsn FROM cdc.lsn_time_mapping WHERE start_lsn >= ? AND tran_id <> 0x00 ORDER BY start_lsn) as next_lsns";
    private static final String GET_MIN_LSN = "SELECT sys.fn_cdc_get_min_lsn('#')";
    private static final String LOCK_TABLE = "SELECT * FROM [#] WITH (TABLOCKX)";
    private static final String SQL_SERVER_VERSION = "SELECT @@VERSION AS 'SQL Server Version'";
    private static final String INCREMENT_LSN = "SELECT sys.fn_cdc_increment_lsn(?)";
    private static final String GET_ALL_CHANGES_FOR_TABLE = "SELECT *# FROM cdc.[fn_cdc_get_all_changes_#](?, ?, N'all update old') order by [__$start_lsn] ASC, [__$seqval] ASC, [__$operation] ASC";
    private final String get_all_changes_for_table;
    protected static final String LSN_TIMESTAMP_SELECT_STATEMENT = "sys.fn_cdc_map_lsn_to_time([__$start_lsn])";
    protected static final String AT_TIME_ZONE_UTC = "AT TIME ZONE 'UTC'";
    private static final String GET_LIST_OF_CDC_ENABLED_TABLES = "EXEC sys.sp_cdc_help_change_data_capture";
    private static final String GET_LIST_OF_NEW_CDC_ENABLED_TABLES = "SELECT * FROM cdc.change_tables WHERE start_lsn BETWEEN ? AND ?";
    private static final String GET_LIST_OF_KEY_COLUMNS = "SELECT * FROM cdc.index_columns WHERE object_id=?";
    private static final Pattern BRACKET_PATTERN = Pattern.compile("[\\[\\]]");
    private static final int CHANGE_TABLE_DATA_COLUMN_OFFSET = 5;
    private static final String URL_PATTERN = "jdbc:sqlserver://${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "};databaseName=${" + JdbcConfiguration.DATABASE + "}";
    private static final JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory(URL_PATTERN, SQLServerDriver.class.getName(), SqlServerConnection.class.getClassLoader(), JdbcConfiguration.PORT.withDefault(SqlServerConnectorConfig.PORT.defaultValueAsString()));
    private final String realDatabaseName = this.retrieveRealDatabaseName();
    private final ZoneId transactionTimezone;
    private final String getAllChangesForTable;
    private final int queryFetchSize;
    private final SqlServerDefaultValueConverter defaultValueConverter;

    public SqlServerConnection(Configuration config, Clock clock, SourceTimestampMode sourceTimestampMode, SqlServerValueConverters valueConverters) {
        this(config, clock, sourceTimestampMode, valueConverters, null, Collections.emptySet());
    }

    public SqlServerConnection(Configuration config, Clock clock, SourceTimestampMode sourceTimestampMode, SqlServerValueConverters valueConverters, Supplier<ClassLoader> classLoaderSupplier, Set<Envelope.Operation> skippedOperations) {
        super(config, FACTORY, classLoaderSupplier);
        boolean supportsAtTimeZone = this.supportsAtTimeZone();
        this.transactionTimezone = this.retrieveTransactionTimezone(supportsAtTimeZone);
        this.defaultValueConverter = new SqlServerDefaultValueConverter(this::connection, valueConverters);
        this.queryFetchSize = this.config().getInteger(CommonConnectorConfig.QUERY_FETCH_SIZE);
        if (!skippedOperations.isEmpty()) {
            HashSet skippedOps = new HashSet();
            StringBuilder getAllChangesForTableStatement = new StringBuilder("SELECT *# FROM cdc.[fn_cdc_get_all_changes_#](?, ?, N'all update old') WHERE __$operation NOT IN (");
            skippedOperations.forEach(operation -> {
                switch (operation) {
                    case CREATE: {
                        skippedOps.add("2");
                        break;
                    }
                    case UPDATE: {
                        skippedOps.add("3");
                        skippedOps.add("4");
                        break;
                    }
                    case DELETE: {
                        skippedOps.add("1");
                    }
                }
            });
            getAllChangesForTableStatement.append(String.join((CharSequence)",", skippedOps));
            getAllChangesForTableStatement.append(") order by [__$start_lsn] ASC, [__$seqval] ASC, [__$operation] ASC");
            this.get_all_changes_for_table = getAllChangesForTableStatement.toString();
        } else {
            this.get_all_changes_for_table = GET_ALL_CHANGES_FOR_TABLE;
        }
        this.getAllChangesForTable = this.get_all_changes_for_table.replaceFirst(STATEMENTS_PLACEHOLDER, Matcher.quoteReplacement(sourceTimestampMode.lsnTimestampSelectStatement(supportsAtTimeZone)));
    }

    public String connectionString() {
        return this.connectionString(URL_PATTERN);
    }

    public Lsn getMaxLsn() throws SQLException {
        return this.queryAndMap(GET_MAX_LSN, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current maximum lsn is {}", (Object)ret);
            return ret;
        }, "Maximum LSN query must return exactly one value"));
    }

    public Lsn getNthTransactionLsnFromBeginning(int maxOffset) throws SQLException {
        return this.prepareQueryAndMap(GET_NTH_TRANSACTION_LSN_FROM_BEGINNING, statement -> statement.setInt(1, maxOffset), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Nth lsn from beginning is {}", (Object)ret);
            return ret;
        }, "Nth LSN query must return exactly one value"));
    }

    public Lsn getNthTransactionLsnFromLast(Lsn lastLsn, int maxOffset) throws SQLException {
        return this.prepareQueryAndMap(GET_NTH_TRANSACTION_LSN_FROM_LAST, statement -> {
            statement.setInt(1, maxOffset);
            statement.setBytes(2, lastLsn.getBinary());
        }, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Nth lsn from last is {}", (Object)ret);
            return ret;
        }, "Nth LSN query must return exactly one value"));
    }

    public Lsn getMaxTransactionLsn() throws SQLException {
        return this.queryAndMap(GET_MAX_TRANSACTION_LSN, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Max transaction lsn is {}", (Object)ret);
            return ret;
        }, "Max transaction LSN query must return exactly one value"));
    }

    public Lsn getMinLsn(String changeTableName) throws SQLException {
        String query = GET_MIN_LSN.replace(STATEMENTS_PLACEHOLDER, changeTableName);
        return this.queryAndMap(query, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current minimum lsn is {}", (Object)ret);
            return ret;
        }, "Minimum LSN query must return exactly one value"));
    }

    public void getChangesForTable(TableId tableId, Lsn fromLsn, Lsn toLsn, JdbcConnection.ResultSetConsumer consumer) throws SQLException {
        String query = this.getAllChangesForTable.replace(STATEMENTS_PLACEHOLDER, this.cdcNameForTable(tableId));
        this.prepareQuery(query, (PreparedStatement statement) -> {
            statement.setBytes(1, fromLsn.getBinary());
            statement.setBytes(2, toLsn.getBinary());
        }, consumer);
    }

    public void getChangesForTables(SqlServerChangeTable[] changeTables, Lsn intervalFromLsn, Lsn intervalToLsn, JdbcConnection.BlockingMultiResultSetConsumer consumer) throws SQLException, InterruptedException {
        String[] queries = new String[changeTables.length];
        JdbcConnection.StatementPreparer[] preparers = new JdbcConnection.StatementPreparer[changeTables.length];
        int idx = 0;
        for (SqlServerChangeTable changeTable : changeTables) {
            String query;
            queries[idx] = query = this.getAllChangesForTable.replace(STATEMENTS_PLACEHOLDER, changeTable.getCaptureInstance());
            Lsn fromLsn = this.getFromLsn(changeTable, intervalFromLsn);
            LOGGER.trace("Getting changes for table {} in range[{}, {}]", new Object[]{changeTable, fromLsn, intervalToLsn});
            preparers[idx] = statement -> {
                if (this.queryFetchSize > 0) {
                    statement.setFetchSize(this.queryFetchSize);
                }
                statement.setBytes(1, fromLsn.getBinary());
                statement.setBytes(2, intervalToLsn.getBinary());
            };
            ++idx;
        }
        this.prepareQuery(queries, preparers, consumer);
    }

    private Lsn getFromLsn(SqlServerChangeTable changeTable, Lsn intervalFromLsn) throws SQLException {
        Lsn fromLsn = changeTable.getStartLsn().compareTo(intervalFromLsn) > 0 ? changeTable.getStartLsn() : intervalFromLsn;
        return fromLsn.getBinary() != null ? fromLsn : this.getMinLsn(changeTable.getCaptureInstance());
    }

    public Lsn incrementLsn(Lsn lsn) throws SQLException {
        String query = INCREMENT_LSN;
        return this.prepareQueryAndMap(INCREMENT_LSN, statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Increasing lsn from {} to {}", (Object)lsn, (Object)ret);
            return ret;
        }, "Increment LSN query must return exactly one value"));
    }

    protected Instant normalize(Timestamp timestamp) {
        Instant instant = timestamp.toInstant();
        if (!this.transactionTimezone.getId().equals("UTC")) {
            instant = instant.atZone(this.transactionTimezone).toLocalDateTime().toInstant(ZoneOffset.UTC);
        }
        return instant;
    }

    public void lockTable(TableId tableId) throws SQLException {
        String lockTableStmt = LOCK_TABLE.replace(STATEMENTS_PLACEHOLDER, tableId.table());
        this.execute(lockTableStmt);
    }

    private String cdcNameForTable(TableId tableId) {
        return tableId.schema() + '_' + tableId.table();
    }

    public Set<SqlServerChangeTable> listOfChangeTables() throws SQLException {
        String query = GET_LIST_OF_CDC_ENABLED_TABLES;
        return this.queryAndMap(GET_LIST_OF_CDC_ENABLED_TABLES, rs -> {
            HashSet<SqlServerChangeTable> changeTables = new HashSet<SqlServerChangeTable>();
            while (rs.next()) {
                changeTables.add(new SqlServerChangeTable(new TableId(this.realDatabaseName, rs.getString(1), rs.getString(2)), rs.getString(3), rs.getInt(4), Lsn.valueOf(rs.getBytes(6)), Lsn.valueOf(rs.getBytes(7)), Arrays.asList(BRACKET_PATTERN.matcher(Optional.ofNullable(rs.getString(15)).orElse("")).replaceAll("").split(", "))));
            }
            return changeTables;
        });
    }

    public Set<SqlServerChangeTable> listOfNewChangeTables(Lsn fromLsn, Lsn toLsn) throws SQLException {
        String query = GET_LIST_OF_NEW_CDC_ENABLED_TABLES;
        return this.prepareQueryAndMap(GET_LIST_OF_NEW_CDC_ENABLED_TABLES, ps -> {
            ps.setBytes(1, fromLsn.getBinary());
            ps.setBytes(2, toLsn.getBinary());
        }, rs -> {
            HashSet<SqlServerChangeTable> changeTables = new HashSet<SqlServerChangeTable>();
            while (rs.next()) {
                changeTables.add(new SqlServerChangeTable(rs.getString(4), rs.getInt(1), Lsn.valueOf(rs.getBytes(5)), Lsn.valueOf(rs.getBytes(6))));
            }
            return changeTables;
        });
    }

    public Table getTableSchemaFromTable(SqlServerChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        ArrayList<Column> columns = new ArrayList<Column>();
        try (ResultSet rs = metadata.getColumns(this.realDatabaseName, changeTable.getSourceTableId().schema(), changeTable.getSourceTableId().table(), null);){
            while (rs.next()) {
                this.readTableColumn(rs, changeTable.getSourceTableId(), null).ifPresent(ce -> {
                    if (changeTable.getCapturedColumns().contains(ce.name())) {
                        columns.add(ce.create());
                    }
                });
            }
        }
        List<String> pkColumnNames = this.readPrimaryKeyOrUniqueIndexNames(metadata, changeTable.getSourceTableId()).stream().filter(column -> changeTable.getCapturedColumns().contains(column)).collect(Collectors.toList());
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public Table getTableSchemaFromChangeTable(SqlServerChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        TableId changeTableId = changeTable.getChangeTableId();
        ArrayList columnEditors = new ArrayList();
        try (ResultSet rs2 = metadata.getColumns(this.realDatabaseName, changeTableId.schema(), changeTableId.table(), null);){
            while (rs2.next()) {
                this.readTableColumn(rs2, changeTableId, null).ifPresent(columnEditors::add);
            }
        }
        List<Column> columns = columnEditors.subList(5, columnEditors.size() - 1).stream().map(c -> c.position(c.position() - 5).create()).collect(Collectors.toList());
        ArrayList<String> pkColumnNames = new ArrayList<String>();
        this.prepareQuery(GET_LIST_OF_KEY_COLUMNS, (PreparedStatement ps) -> ps.setInt(1, changeTable.getChangeTableObjectId()), (ResultSet rs) -> {
            while (rs.next()) {
                pkColumnNames.add(rs.getString(2));
            }
        });
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public String getNameOfChangeTable(String captureName) {
        return captureName + "_CT";
    }

    public String getRealDatabaseName() {
        return this.realDatabaseName;
    }

    private ZoneId retrieveTransactionTimezone(boolean supportsAtTimeZone) {
        String serverTimezoneConfig = this.config().getString(SERVER_TIMEZONE_PROP_NAME);
        if (supportsAtTimeZone) {
            if (serverTimezoneConfig != null) {
                LOGGER.warn("The '{}' option should not be specified with SQL Server 2016 and newer", (Object)SERVER_TIMEZONE_PROP_NAME);
            }
        } else if (serverTimezoneConfig == null) {
            LOGGER.warn("The '{}' option should be specified to avoid incorrect timestamp values in case of different timezones between the database server and this connector's JVM.", (Object)SERVER_TIMEZONE_PROP_NAME);
        }
        return serverTimezoneConfig == null ? ZoneId.of("UTC") : ZoneId.of(serverTimezoneConfig, ZoneId.SHORT_IDS);
    }

    private String retrieveRealDatabaseName() {
        try {
            return this.queryAndMap(GET_DATABASE_NAME, this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    private boolean supportsAtTimeZone() {
        try {
            return this.getSqlServerVersion().orElse(Integer.MAX_VALUE) > 2016;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't obtain database server version; assuming 'AT TIME ZONE' is not supported.", (Throwable)e);
            return false;
        }
    }

    private Optional<Integer> getSqlServerVersion() {
        try {
            String version = this.queryAndMap(SQL_SERVER_VERSION, this.singleResultMapper(rs -> rs.getString(1), "Could not obtain SQL Server version"));
            if (!version.startsWith("Microsoft SQL Server ")) {
                return Optional.empty();
            }
            return Optional.of(Integer.valueOf(version.substring(21, 25)));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't obtain database server version", e);
        }
    }

    @Override
    protected Optional<Object> getDefaultValue(Column column, String defaultValue) {
        return this.defaultValueConverter.parseDefaultValue(column, defaultValue);
    }

    @Override
    protected boolean isTableUniqueIndexIncluded(String indexName, String columnName) {
        return indexName != null;
    }

    @Override
    public <T extends DatabaseSchema<TableId>> Object getColumnValue(ResultSet rs, int columnIndex, Column column, Table table, T schema) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnType = metaData.getColumnType(columnIndex);
        if (columnType == 92) {
            return rs.getTimestamp(columnIndex);
        }
        return super.getColumnValue(rs, columnIndex, column, table, schema);
    }

    @Override
    public String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT TOP ");
        sql.append(limit).append(' ').append(projection).append(" FROM ");
        sql.append(this.quotedTableIdString(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        sql.append(" ORDER BY ").append(orderBy);
        return sql.toString();
    }

    @Override
    public String quotedTableIdString(TableId tableId) {
        return "[" + tableId.schema() + "].[" + tableId.table() + "]";
    }

    public static class CdcEnabledTable {
        private final String tableId;
        private final String captureName;
        private final Lsn fromLsn;

        private CdcEnabledTable(String tableId, String captureName, Lsn fromLsn) {
            this.tableId = tableId;
            this.captureName = captureName;
            this.fromLsn = fromLsn;
        }

        public String getTableId() {
            return this.tableId;
        }

        public String getCaptureName() {
            return this.captureName;
        }

        public Lsn getFromLsn() {
            return this.fromLsn;
        }
    }
}

