/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.EnumeratedValue;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.util.Clock;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum SourceTimestampMode implements EnumeratedValue
{
    COMMIT("commit"){

        @Override
        protected Instant getTimestamp(SqlServerConnection connection, Clock clock, ResultSet resultSet) throws SQLException {
            return connection.normalize(resultSet.getTimestamp(resultSet.getMetaData().getColumnCount()));
        }

        @Override
        protected String lsnTimestampSelectStatement(boolean supportsAtTimeZone) {
            String result = ", sys.fn_cdc_map_lsn_to_time([__$start_lsn])";
            if (supportsAtTimeZone) {
                result = result + " AT TIME ZONE 'UTC'";
            }
            return result;
        }
    }
    ,
    PROCESSING("processing"){

        @Override
        protected Instant getTimestamp(SqlServerConnection connection, Clock clock, ResultSet resultSet) {
            return clock.currentTime();
        }

        @Override
        protected String lsnTimestampSelectStatement(boolean supportsAtTimeZone) {
            return "";
        }
    };

    private final String value;

    private SourceTimestampMode(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected abstract Instant getTimestamp(SqlServerConnection var1, Clock var2, ResultSet var3) throws SQLException;

    protected abstract String lsnTimestampSelectStatement(boolean var1);

    protected List<String> getResultColumnNames(ResultSetMetaData rsmd, int columnDataOffset) throws SQLException {
        int columnCount = rsmd.getColumnCount() - (columnDataOffset - 1);
        if (this.equals(COMMIT)) {
            --columnCount;
        }
        ArrayList<String> columns = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columns.add(rsmd.getColumnName(columnDataOffset + i));
        }
        return columns;
    }

    public static SourceTimestampMode getDefaultMode() {
        return COMMIT;
    }

    static SourceTimestampMode fromMode(String mode) {
        return Arrays.stream(SourceTimestampMode.values()).filter(s2 -> s2.name().equalsIgnoreCase(mode)).findFirst().orElseGet(SourceTimestampMode::getDefaultMode);
    }
}

