/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.utils;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.utils.PostgresUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PostgresUtilsTest {
    @Test
    public void testSplitScanQuery() {
        Table table = Table.editor().tableId(TableId.parse((String)"db1.schema1.table1")).addColumn(Column.editor().name("id").type("int8").create()).create();
        String splitScanSQL = PostgresUtils.buildSplitScanQuery((Table)table, (SeaTunnelRowType)new SeaTunnelRowType(new String[]{"id"}, new SeaTunnelDataType[]{BasicType.LONG_TYPE}), (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)"SELECT * FROM \"schema1\".\"table1\" WHERE \"id\" >= ? AND NOT (\"id\" = ?) AND \"id\" <= ?", (Object)splitScanSQL);
        splitScanSQL = PostgresUtils.buildSplitScanQuery((Table)table, (SeaTunnelRowType)new SeaTunnelRowType(new String[]{"id"}, new SeaTunnelDataType[]{BasicType.LONG_TYPE}), (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"SELECT * FROM \"schema1\".\"table1\"", (Object)splitScanSQL);
        splitScanSQL = PostgresUtils.buildSplitScanQuery((Table)table, (SeaTunnelRowType)new SeaTunnelRowType(new String[]{"id"}, new SeaTunnelDataType[]{BasicType.LONG_TYPE}), (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"SELECT * FROM \"schema1\".\"table1\" WHERE \"id\" <= ? AND NOT (\"id\" = ?)", (Object)splitScanSQL);
        table = Table.editor().tableId(TableId.parse((String)"db1.schema1.table1")).addColumn(Column.editor().name("id").type("uuid").create()).create();
        splitScanSQL = PostgresUtils.buildSplitScanQuery((Table)table, (SeaTunnelRowType)new SeaTunnelRowType(new String[]{"id"}, new SeaTunnelDataType[]{BasicType.STRING_TYPE}), (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"SELECT * FROM \"schema1\".\"table1\" WHERE \"id\"::text >= ?", (Object)splitScanSQL);
    }
}

