/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.statelang.parser.impl;

import java.util.Map;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.statelang.domain.RecoverStrategy;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.StateMachine;
import org.apache.seata.saga.statelang.domain.StateType;
import org.apache.seata.saga.statelang.domain.impl.AbstractTaskState;
import org.apache.seata.saga.statelang.domain.impl.BaseState;
import org.apache.seata.saga.statelang.domain.impl.StateMachineImpl;
import org.apache.seata.saga.statelang.parser.JsonParser;
import org.apache.seata.saga.statelang.parser.JsonParserFactory;
import org.apache.seata.saga.statelang.parser.StateMachineParser;
import org.apache.seata.saga.statelang.parser.StateParser;
import org.apache.seata.saga.statelang.parser.StateParserFactory;
import org.apache.seata.saga.statelang.parser.utils.DesignerJsonTransformer;
import org.apache.seata.saga.statelang.validator.StateMachineValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineParserImpl
implements StateMachineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachineParserImpl.class);
    private String jsonParserName = "fastjson";
    private final StateMachineValidator validator = new StateMachineValidator();

    public StateMachineParserImpl(String jsonParserName) {
        if (StringUtils.isNotBlank((String)jsonParserName)) {
            this.jsonParserName = jsonParserName;
        }
    }

    @Override
    public StateMachine parse(String json) {
        Object isCompensatePersistModeUpdate;
        Object isRetryPersistModeUpdate;
        Object isPersist;
        JsonParser jsonParser = JsonParserFactory.getJsonParser(this.jsonParserName);
        if (jsonParser == null) {
            throw new RuntimeException("Cannot find JsonParer by name: " + this.jsonParserName);
        }
        Map<String, Object> node = jsonParser.parse(json, Map.class, true);
        if (DesignerJsonTransformer.isDesignerJson(node)) {
            node = DesignerJsonTransformer.toStandardJson(node);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("===== Transformed standard state language:\n{}", (Object)jsonParser.toJsonString(node, true));
            }
        }
        StateMachineImpl stateMachine = new StateMachineImpl();
        stateMachine.setName((String)node.get("Name"));
        stateMachine.setComment((String)node.get("Comment"));
        stateMachine.setVersion((String)node.get("Version"));
        stateMachine.setStartState((String)node.get("StartState"));
        String recoverStrategy = (String)node.get("RecoverStrategy");
        if (StringUtils.isNotBlank((String)recoverStrategy)) {
            stateMachine.setRecoverStrategy(RecoverStrategy.valueOf(recoverStrategy));
        }
        if (Boolean.FALSE.equals(isPersist = node.get("IsPersist"))) {
            stateMachine.setPersist(false);
        }
        if ((isRetryPersistModeUpdate = node.get("IsRetryPersistModeUpdate")) instanceof Boolean) {
            stateMachine.setRetryPersistModeUpdate(Boolean.TRUE.equals(isRetryPersistModeUpdate));
        }
        if ((isCompensatePersistModeUpdate = node.get("IsCompensatePersistModeUpdate")) instanceof Boolean) {
            stateMachine.setCompensatePersistModeUpdate(Boolean.TRUE.equals(isCompensatePersistModeUpdate));
        }
        Map statesNode = (Map)node.get("States");
        statesNode.forEach((stateName, value) -> {
            Map stateNode = (Map)value;
            StateType stateType = StateType.getStateType((String)stateNode.get("Type"));
            StateParser stateParser = StateParserFactory.getStateParser(stateType);
            if (stateParser == null) {
                throw new IllegalArgumentException("State Type [" + (Object)((Object)stateType) + "] is not support");
            }
            Object state = stateParser.parse(stateNode);
            if (state instanceof BaseState) {
                ((BaseState)state).setName((String)stateName);
            }
            if (stateMachine.getState((String)stateName) != null) {
                throw new IllegalArgumentException("State[name:" + stateName + "] is already exists");
            }
            stateMachine.putState((String)stateName, (State)state);
        });
        Map<String, State> stateMap = stateMachine.getStates();
        for (State state : stateMap.values()) {
            AbstractTaskState taskState;
            if (!(state instanceof AbstractTaskState) || !StringUtils.isNotBlank((String)(taskState = (AbstractTaskState)state).getCompensateState())) continue;
            taskState.setForUpdate(true);
            State compState = stateMap.get(taskState.getCompensateState());
            if (!(compState instanceof AbstractTaskState)) continue;
            ((AbstractTaskState)compState).setForCompensation(true);
        }
        this.validator.validate(stateMachine);
        return stateMachine;
    }

    public String getJsonParserName() {
        return this.jsonParserName;
    }

    public void setJsonParserName(String jsonParserName) {
        this.jsonParserName = jsonParserName;
    }
}

