/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.strategy.impl;

import java.util.List;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.pcext.utils.CompensationHolder;
import org.apache.seata.saga.engine.strategy.StatusDecisionStrategy;
import org.apache.seata.saga.engine.utils.ExceptionUtils;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.ExecutionStatus;
import org.apache.seata.saga.statelang.domain.StateInstance;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStatusDecisionStrategy
implements StatusDecisionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatusDecisionStrategy.class);

    public static void decideMachineCompensateStatus(StateMachineInstance stateMachineInstance, CompensationHolder compensationHolder) {
        if (stateMachineInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateMachineInstance.getStatus())) {
            stateMachineInstance.setStatus(ExecutionStatus.UN);
        }
        if (!compensationHolder.getStateStackNeedCompensation().isEmpty()) {
            boolean hasCompensateSUorUN = false;
            for (StateInstance forCompensateState : compensationHolder.getStatesForCompensation().values()) {
                if (!ExecutionStatus.UN.equals((Object)forCompensateState.getStatus()) && !ExecutionStatus.SU.equals((Object)forCompensateState.getStatus())) continue;
                hasCompensateSUorUN = true;
                break;
            }
            if (hasCompensateSUorUN) {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.UN);
            } else {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.FA);
            }
        } else {
            boolean hasCompensateError = false;
            for (StateInstance forCompensateState : compensationHolder.getStatesForCompensation().values()) {
                if (ExecutionStatus.SU.equals((Object)forCompensateState.getStatus())) continue;
                hasCompensateError = true;
                break;
            }
            if (hasCompensateError) {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.UN);
            } else {
                stateMachineInstance.setCompensationStatus(ExecutionStatus.SU);
            }
        }
    }

    public static void setMachineStatusBasedOnStateListAndException(StateMachineInstance stateMachineInstance, List<StateInstance> stateList, Exception exp) {
        boolean hasSetStatus = false;
        boolean hasSuccessUpdateService = false;
        if (CollectionUtils.isNotEmpty(stateList)) {
            boolean hasUnsuccessService = false;
            for (int i = stateList.size() - 1; i >= 0; --i) {
                StateInstance stateInstance = stateList.get(i);
                if (stateInstance.isIgnoreStatus() || stateInstance.isForCompensation()) continue;
                if (ExecutionStatus.UN.equals((Object)stateInstance.getStatus())) {
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                    hasSetStatus = true;
                    continue;
                }
                if (ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                    if (!"ServiceTask".equals(stateInstance.getType()) || !stateInstance.isForUpdate() || stateInstance.isForCompensation()) continue;
                    hasSuccessUpdateService = true;
                    continue;
                }
                if (ExecutionStatus.SK.equals((Object)stateInstance.getStatus())) continue;
                hasUnsuccessService = true;
            }
            if (!hasSetStatus && hasUnsuccessService) {
                if (hasSuccessUpdateService) {
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                } else {
                    stateMachineInstance.setStatus(ExecutionStatus.FA);
                }
                hasSetStatus = true;
            }
        }
        if (!hasSetStatus) {
            DefaultStatusDecisionStrategy.setMachineStatusBasedOnException(stateMachineInstance, exp, hasSuccessUpdateService);
        }
    }

    public static void setMachineStatusBasedOnException(StateMachineInstance stateMachineInstance, Exception exp, boolean hasSuccessUpdateService) {
        if (exp == null) {
            stateMachineInstance.setStatus(ExecutionStatus.SU);
        } else if (exp instanceof EngineExecutionException && FrameworkErrorCode.StateMachineExecutionTimeout.equals((Object)((EngineExecutionException)((Object)exp)).getErrcode())) {
            stateMachineInstance.setStatus(ExecutionStatus.UN);
        } else if (hasSuccessUpdateService) {
            stateMachineInstance.setStatus(ExecutionStatus.UN);
        } else {
            ExceptionUtils.NetExceptionType t = ExceptionUtils.getNetExceptionType(exp);
            if (t != null) {
                if (t.equals((Object)ExceptionUtils.NetExceptionType.CONNECT_EXCEPTION) || t.equals((Object)ExceptionUtils.NetExceptionType.CONNECT_TIMEOUT_EXCEPTION) || t.equals((Object)ExceptionUtils.NetExceptionType.NOT_NET_EXCEPTION)) {
                    stateMachineInstance.setStatus(ExecutionStatus.FA);
                } else if (t.equals((Object)ExceptionUtils.NetExceptionType.READ_TIMEOUT_EXCEPTION)) {
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                }
            } else {
                stateMachineInstance.setStatus(ExecutionStatus.UN);
            }
        }
    }

    @Override
    public void decideOnEndState(ProcessContext context, StateMachineInstance stateMachineInstance, Exception exp) {
        if (ExecutionStatus.RU.equals((Object)stateMachineInstance.getCompensationStatus())) {
            CompensationHolder compensationHolder = CompensationHolder.getCurrent(context, true);
            DefaultStatusDecisionStrategy.decideMachineCompensateStatus(stateMachineInstance, compensationHolder);
        } else {
            Object failEndStateFlag = context.getVariable("_fail_end_state_flag_");
            boolean isComeFromFailEndState = failEndStateFlag != null && (Boolean)failEndStateFlag != false;
            this.decideMachineForwardExecutionStatus(stateMachineInstance, exp, isComeFromFailEndState);
        }
        if (stateMachineInstance.getCompensationStatus() != null && "forward".equals(context.getVariable("_operation_name_")) && ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus())) {
            stateMachineInstance.setCompensationStatus(ExecutionStatus.FA);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("StateMachine Instance[id:{},name:{}] execute finish with status[{}], compensation status [{}].", new Object[]{stateMachineInstance.getId(), stateMachineInstance.getStateMachine().getName(), stateMachineInstance.getStatus(), stateMachineInstance.getCompensationStatus()});
        }
    }

    @Override
    public void decideOnTaskStateFail(ProcessContext context, StateMachineInstance stateMachineInstance, Exception exp) {
        if (!this.decideMachineForwardExecutionStatus(stateMachineInstance, exp, true)) {
            stateMachineInstance.setCompensationStatus(ExecutionStatus.UN);
        }
    }

    @Override
    public boolean decideMachineForwardExecutionStatus(StateMachineInstance stateMachineInstance, Exception exp, boolean specialPolicy) {
        boolean result = false;
        if (stateMachineInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateMachineInstance.getStatus())) {
            result = true;
            List stateList = stateMachineInstance.getStateList();
            DefaultStatusDecisionStrategy.setMachineStatusBasedOnStateListAndException(stateMachineInstance, stateList, exp);
            if (specialPolicy && ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus())) {
                for (StateInstance stateInstance : stateMachineInstance.getStateList()) {
                    if (stateInstance.isIgnoreStatus() || !stateInstance.isForUpdate() && !stateInstance.isForCompensation()) continue;
                    stateMachineInstance.setStatus(ExecutionStatus.UN);
                    break;
                }
                if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getStatus())) {
                    stateMachineInstance.setStatus(ExecutionStatus.FA);
                }
            }
        }
        return result;
    }
}

