/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.repo.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.repo.StateMachineRepository;
import org.apache.seata.saga.engine.sequence.SeqGenerator;
import org.apache.seata.saga.engine.sequence.UUIDSeqGenerator;
import org.apache.seata.saga.engine.store.StateLangStore;
import org.apache.seata.saga.statelang.domain.StateMachine;
import org.apache.seata.saga.statelang.parser.StateMachineParserFactory;
import org.apache.seata.saga.statelang.parser.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineRepositoryImpl
implements StateMachineRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachineRepositoryImpl.class);
    private Map<String, Item> stateMachineMapByNameAndTenant = new ConcurrentHashMap<String, Item>();
    private Map<String, Item> stateMachineMapById = new ConcurrentHashMap<String, Item>();
    private StateLangStore stateLangStore;
    private SeqGenerator seqGenerator = new UUIDSeqGenerator();
    private String charset = "UTF-8";
    private String defaultTenantId;
    private String jsonParserName = "fastjson";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateMachine getStateMachineById(String stateMachineId) {
        Item item = (Item)CollectionUtils.computeIfAbsent(this.stateMachineMapById, (Object)stateMachineId, key -> new Item());
        if (item.getValue() == null && this.stateLangStore != null) {
            Item item2 = item;
            synchronized (item2) {
                StateMachine stateMachine;
                if (item.getValue() == null && (stateMachine = this.stateLangStore.getStateMachineById(stateMachineId)) != null) {
                    StateMachine parsedStatMachine = StateMachineParserFactory.getStateMachineParser((String)this.jsonParserName).parse(stateMachine.getContent());
                    if (parsedStatMachine == null) {
                        throw new RuntimeException("Parse State Language failed, stateMachineId:" + stateMachine.getId() + ", name:" + stateMachine.getName());
                    }
                    stateMachine.setStartState(parsedStatMachine.getStartState());
                    stateMachine.getStates().putAll(parsedStatMachine.getStates());
                    item.setValue(stateMachine);
                    this.stateMachineMapById.put(stateMachine.getName() + "_" + stateMachine.getTenantId(), item);
                }
            }
        }
        return item.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateMachine getStateMachine(String stateMachineName, String tenantId) {
        Item item = (Item)CollectionUtils.computeIfAbsent(this.stateMachineMapByNameAndTenant, (Object)(stateMachineName + "_" + tenantId), key -> new Item());
        if (item.getValue() == null && this.stateLangStore != null) {
            Item item2 = item;
            synchronized (item2) {
                StateMachine stateMachine;
                if (item.getValue() == null && (stateMachine = this.stateLangStore.getLastVersionStateMachine(stateMachineName, tenantId)) != null) {
                    StateMachine parsedStatMachine = StateMachineParserFactory.getStateMachineParser((String)this.jsonParserName).parse(stateMachine.getContent());
                    if (parsedStatMachine == null) {
                        throw new RuntimeException("Parse State Language failed, stateMachineId:" + stateMachine.getId() + ", name:" + stateMachine.getName());
                    }
                    stateMachine.setStartState(parsedStatMachine.getStartState());
                    stateMachine.getStates().putAll(parsedStatMachine.getStates());
                    item.setValue(stateMachine);
                    this.stateMachineMapById.put(stateMachine.getId(), item);
                }
            }
        }
        return item.getValue();
    }

    @Override
    public StateMachine getStateMachine(String stateMachineName, String tenantId, String version) {
        throw new UnsupportedOperationException("not implement yet");
    }

    @Override
    public StateMachine registryStateMachine(StateMachine stateMachine) {
        String stateMachineName = stateMachine.getName();
        String tenantId = stateMachine.getTenantId();
        if (this.stateLangStore != null) {
            StateMachine oldStateMachine = this.stateLangStore.getLastVersionStateMachine(stateMachineName, tenantId);
            if (oldStateMachine != null) {
                byte[] oldBytesContent = null;
                byte[] bytesContent = null;
                try {
                    oldBytesContent = oldStateMachine.getContent().getBytes(this.charset);
                    bytesContent = stateMachine.getContent().getBytes(this.charset);
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                if (Arrays.equals(bytesContent, oldBytesContent) && stateMachine.getVersion() != null && stateMachine.getVersion().equals(oldStateMachine.getVersion())) {
                    LOGGER.info("StateMachine[{}] is already exist a same version", (Object)stateMachineName);
                    stateMachine.setId(oldStateMachine.getId());
                    stateMachine.setGmtCreate(oldStateMachine.getGmtCreate());
                    Item item = new Item(stateMachine);
                    this.stateMachineMapByNameAndTenant.put(stateMachineName + "_" + tenantId, item);
                    this.stateMachineMapById.put(stateMachine.getId(), item);
                    return stateMachine;
                }
            }
            if (StringUtils.isBlank((String)stateMachine.getId())) {
                stateMachine.setId(this.seqGenerator.generate("STATE_MACHINE"));
            }
            stateMachine.setGmtCreate(new Date());
            this.stateLangStore.storeStateMachine(stateMachine);
        }
        if (StringUtils.isBlank((String)stateMachine.getId())) {
            stateMachine.setId(this.seqGenerator.generate("STATE_MACHINE"));
        }
        Item item = new Item(stateMachine);
        this.stateMachineMapByNameAndTenant.put(stateMachineName + "_" + tenantId, item);
        this.stateMachineMapById.put(stateMachine.getId(), item);
        return stateMachine;
    }

    @Override
    public void registryByResources(InputStream[] resourceAsStreamArray, String tenantId) throws IOException {
        InputStream[] inputStreamArray = resourceAsStreamArray;
        int n = inputStreamArray.length;
        for (int i = 0; i < n; ++i) {
            String json;
            InputStream resource;
            try (InputStream is = resource = inputStreamArray[i];){
                json = IOUtils.toString((InputStream)is, (String)this.charset);
            }
            StateMachine stateMachine = StateMachineParserFactory.getStateMachineParser((String)this.jsonParserName).parse(json);
            if (stateMachine == null) continue;
            stateMachine.setContent(json);
            if (StringUtils.isBlank((String)stateMachine.getTenantId())) {
                stateMachine.setTenantId(tenantId);
            }
            this.registryStateMachine(stateMachine);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("===== StateMachine Loaded: \n{}", (Object)json);
        }
    }

    public void setStateLangStore(StateLangStore stateLangStore) {
        this.stateLangStore = stateLangStore;
    }

    public void setSeqGenerator(SeqGenerator seqGenerator) {
        this.seqGenerator = seqGenerator;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    public void setDefaultTenantId(String defaultTenantId) {
        this.defaultTenantId = defaultTenantId;
    }

    public String getJsonParserName() {
        return this.jsonParserName;
    }

    public void setJsonParserName(String jsonParserName) {
        this.jsonParserName = jsonParserName;
    }

    private static class Item {
        private StateMachine value;

        private Item() {
        }

        private Item(StateMachine value) {
            this.value = value;
        }

        public StateMachine getValue() {
            return this.value;
        }

        public void setValue(StateMachine value) {
            this.value = value;
        }
    }
}

