/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.expression.Expression;
import org.apache.seata.saga.engine.expression.ExpressionResolver;
import org.apache.seata.saga.engine.expression.seq.SequenceExpression;
import org.apache.seata.saga.statelang.domain.StateInstance;
import org.apache.seata.saga.statelang.domain.impl.AbstractTaskState;
import org.apache.seata.saga.statelang.domain.impl.StateInstanceImpl;

public class ParameterUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> createInputParams(ExpressionResolver expressionResolver, StateInstanceImpl stateInstance, AbstractTaskState serviceTaskState, Object variablesFrom) {
        List inputAssignments = serviceTaskState.getInput();
        if (CollectionUtils.isEmpty((Collection)inputAssignments)) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> inputExpressions = serviceTaskState.getInputExpressions();
        if (inputExpressions == null) {
            AbstractTaskState abstractTaskState = serviceTaskState;
            synchronized (abstractTaskState) {
                inputExpressions = serviceTaskState.getInputExpressions();
                if (inputExpressions == null) {
                    inputExpressions = new ArrayList<Object>(inputAssignments.size());
                    for (Object e : inputAssignments) {
                        inputExpressions.add(ParameterUtils.createValueExpression(expressionResolver, e));
                    }
                }
                serviceTaskState.setInputExpressions((List)inputExpressions);
            }
        }
        ArrayList<Object> inputValues = new ArrayList<Object>(inputExpressions.size());
        for (Object e : inputExpressions) {
            Object value = ParameterUtils.getValue(e, variablesFrom, (StateInstance)stateInstance);
            inputValues.add(value);
        }
        return inputValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> createOutputParams(ExpressionResolver expressionResolver, AbstractTaskState serviceTaskState, Object variablesFrom) {
        Map outputAssignments = serviceTaskState.getOutput();
        if (CollectionUtils.isEmpty((Map)outputAssignments)) {
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap outputExpressions = serviceTaskState.getOutputExpressions();
        if (outputExpressions == null) {
            AbstractTaskState abstractTaskState = serviceTaskState;
            synchronized (abstractTaskState) {
                outputExpressions = serviceTaskState.getOutputExpressions();
                if (outputExpressions == null) {
                    outputExpressions = new LinkedHashMap(outputAssignments.size());
                    for (Map.Entry entry : outputAssignments.entrySet()) {
                        outputExpressions.put(entry.getKey(), ParameterUtils.createValueExpression(expressionResolver, entry.getValue()));
                    }
                }
                serviceTaskState.setOutputExpressions((Map)outputExpressions);
            }
        }
        LinkedHashMap<String, Object> outputValues = new LinkedHashMap<String, Object>(outputExpressions.size());
        for (String string : outputExpressions.keySet()) {
            outputValues.put(string, ParameterUtils.getValue(outputExpressions.get(string), variablesFrom, null));
        }
        return outputValues;
    }

    public static Object getValue(Object valueExpression, Object variablesFrom, StateInstance stateInstance) {
        if (valueExpression instanceof Expression) {
            Object value2 = ((Expression)valueExpression).getValue(variablesFrom);
            if (value2 != null && stateInstance != null && StringUtils.isEmpty((CharSequence)stateInstance.getBusinessKey()) && valueExpression instanceof SequenceExpression) {
                stateInstance.setBusinessKey(String.valueOf(value2));
            }
            return value2;
        }
        if (valueExpression instanceof Map) {
            Map mapValueExpression = (Map)valueExpression;
            LinkedHashMap mapValue = new LinkedHashMap();
            mapValueExpression.forEach((key, value) -> {
                if ((value = ParameterUtils.getValue(value, variablesFrom, stateInstance)) != null) {
                    mapValue.put(key, value);
                }
            });
            return mapValue;
        }
        if (valueExpression instanceof List) {
            List listValueExpression = (List)valueExpression;
            ArrayList<Object> listValue = new ArrayList<Object>(listValueExpression.size());
            for (Object aValueExpression : listValueExpression) {
                listValue.add(ParameterUtils.getValue(aValueExpression, variablesFrom, stateInstance));
            }
            return listValue;
        }
        return valueExpression;
    }

    public static Object createValueExpression(ExpressionResolver expressionResolver, Object paramAssignment) {
        Object valueExpression;
        if (paramAssignment instanceof Expression) {
            valueExpression = paramAssignment;
        } else if (paramAssignment instanceof Map) {
            Map paramMapAssignment = paramAssignment;
            LinkedHashMap paramMap = new LinkedHashMap(paramMapAssignment.size());
            paramMapAssignment.forEach((paramName, valueAssignment) -> paramMap.put(paramName, ParameterUtils.createValueExpression(expressionResolver, valueAssignment)));
            valueExpression = paramMap;
        } else if (paramAssignment instanceof List) {
            List paramListAssignment = (List)((Object)paramAssignment);
            ArrayList<Object> paramList = new ArrayList<Object>(paramListAssignment.size());
            for (Object aParamAssignment : paramListAssignment) {
                paramList.add(ParameterUtils.createValueExpression(expressionResolver, aParamAssignment));
            }
            valueExpression = paramList;
        } else {
            valueExpression = paramAssignment instanceof String && ((String)((Object)paramAssignment)).startsWith("$") ? expressionResolver.getExpression((String)((Object)paramAssignment)) : paramAssignment;
        }
        return valueExpression;
    }
}

