/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.interceptors;

import java.util.List;
import java.util.Map;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.pcext.InterceptableStateHandler;
import org.apache.seata.saga.engine.pcext.StateHandlerInterceptor;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.handlers.ScriptTaskStateHandler;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.engine.pcext.utils.ParameterUtils;
import org.apache.seata.saga.engine.utils.ExceptionUtils;
import org.apache.seata.saga.proctrl.HierarchicalProcessContext;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;
import org.apache.seata.saga.statelang.domain.impl.AbstractTaskState;
import org.apache.seata.saga.statelang.domain.impl.ScriptTaskStateImpl;

@LoadLevel(name="ScriptTask", order=100)
public class ScriptTaskHandlerInterceptor
implements StateHandlerInterceptor {
    @Override
    public boolean match(Class<? extends InterceptableStateHandler> clazz) {
        return clazz != null && ScriptTaskStateHandler.class.isAssignableFrom(clazz);
    }

    @Override
    public void preProcess(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        Map contextVariables = (Map)context.getVariable("context");
        ScriptTaskStateImpl state = (ScriptTaskStateImpl)instruction.getState(context);
        List<Object> serviceInputParams = null;
        if (contextVariables != null) {
            try {
                serviceInputParams = ParameterUtils.createInputParams(stateMachineConfig.getExpressionResolver(), null, (AbstractTaskState)state, contextVariables);
            }
            catch (Exception e) {
                String message = "Task [" + state.getName() + "] input parameters assign failed, please check 'Input' expression:" + e.getMessage();
                EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(e, FrameworkErrorCode.VariablesAssignError, message, stateMachineInstance, state.getName());
                EngineUtils.failStateMachine(context, (Exception)((Object)exception));
                throw exception;
            }
        }
        ((HierarchicalProcessContext)context).setVariableLocally("inputParams", serviceInputParams);
    }

    @Override
    public void postProcess(ProcessContext context, Exception exp) throws EngineExecutionException {
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        ScriptTaskStateImpl state = (ScriptTaskStateImpl)instruction.getState(context);
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        if (exp == null) {
            exp = (Exception)context.getVariable("currentException");
        }
        Map contextVariables = (Map)context.getVariable("context");
        Object serviceOutputParams = context.getVariable("outputParams");
        if (serviceOutputParams != null) {
            try {
                Map<String, Object> outputVariablesToContext = ParameterUtils.createOutputParams(stateMachineConfig.getExpressionResolver(), (AbstractTaskState)state, serviceOutputParams);
                if (CollectionUtils.isNotEmpty(outputVariablesToContext)) {
                    contextVariables.putAll(outputVariablesToContext);
                }
            }
            catch (Exception e) {
                String message = "Task [" + state.getName() + "] output parameters assign failed, please check 'Output' expression:" + e.getMessage();
                EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(e, FrameworkErrorCode.VariablesAssignError, message, stateMachineInstance, state.getName());
                EngineUtils.failStateMachine(context, (Exception)((Object)exception));
                throw exception;
            }
        }
        context.removeVariable("outputParams");
        context.removeVariable("inputParams");
        if (exp != null && context.getVariable("_is_exception_not_catch_") != null && ((Boolean)context.getVariable("_is_exception_not_catch_")).booleanValue()) {
            context.removeVariable("_is_exception_not_catch_");
            EngineUtils.failStateMachine(context, exp);
        }
    }
}

