/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.handlers;

import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.pcext.StateHandler;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.utils.CompensationHolder;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.ExecutionStatus;
import org.apache.seata.saga.statelang.domain.StateInstance;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;

public class CompensationTriggerStateHandler
implements StateHandler {
    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        List<StateInstance> stateListToBeCompensated;
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        List stateInstanceList = stateMachineInstance.getStateList();
        if (CollectionUtils.isEmpty((Collection)stateInstanceList)) {
            stateInstanceList = stateMachineConfig.getStateLogStore().queryStateInstanceListByMachineInstanceId(stateMachineInstance.getId());
        }
        if (CollectionUtils.isNotEmpty(stateListToBeCompensated = CompensationHolder.findStateInstListToBeCompensated(context, stateInstanceList))) {
            Exception e = (Exception)context.removeVariable("currentException");
            if (e != null) {
                stateMachineInstance.setException(e);
            }
            Stack<StateInstance> stateStackToBeCompensated = CompensationHolder.getCurrent(context, true).getStateStackNeedCompensation();
            stateStackToBeCompensated.addAll(stateListToBeCompensated);
            if (stateMachineInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateMachineInstance.getStatus())) {
                stateMachineInstance.setStatus(ExecutionStatus.UN);
            }
            stateMachineInstance.setCompensationStatus(ExecutionStatus.RU);
            context.setVariable("_is_compensating_", (Object)instruction.getState(context));
        } else {
            EngineUtils.endStateMachine(context);
        }
    }
}

