/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.handlers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.expression.Expression;
import org.apache.seata.saga.engine.expression.ExpressionResolver;
import org.apache.seata.saga.engine.pcext.StateHandler;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.engine.utils.ExceptionUtils;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.ChoiceState;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;
import org.apache.seata.saga.statelang.domain.impl.ChoiceStateImpl;

public class ChoiceStateHandler
implements StateHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        ChoiceStateImpl choiceState = (ChoiceStateImpl)instruction.getState(context);
        LinkedHashMap<Expression, String> choiceEvaluators = choiceState.getChoiceEvaluators();
        if (choiceEvaluators == null) {
            ChoiceStateImpl choiceStateImpl = choiceState;
            synchronized (choiceStateImpl) {
                choiceEvaluators = choiceState.getChoiceEvaluators();
                if (choiceEvaluators == null) {
                    List choices = choiceState.getChoices();
                    if (choices == null) {
                        choiceEvaluators = new LinkedHashMap<Expression, String>(0);
                    } else {
                        choiceEvaluators = new LinkedHashMap(choices.size());
                        ExpressionResolver resolver = ((StateMachineConfig)context.getVariable("_statemachine_config_")).getExpressionResolver();
                        Iterator iterator = choices.iterator();
                        while (iterator.hasNext()) {
                            ChoiceState.Choice choice = (ChoiceState.Choice)iterator.next();
                            Expression evaluator = resolver.getExpression(choice.getExpression());
                            choiceEvaluators.put(evaluator, choice.getNext());
                        }
                    }
                    choiceState.setChoiceEvaluators(choiceEvaluators);
                }
            }
        }
        for (Map.Entry entry : choiceEvaluators.entrySet()) {
            Expression expression = (Expression)entry.getKey();
            if (!Boolean.TRUE.equals(expression.getValue(context.getVariable("context")))) continue;
            context.setVariable("_current_choice_", entry.getValue());
            return;
        }
        if (StringUtils.isEmpty((CharSequence)choiceState.getDefault())) {
            StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
            EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(FrameworkErrorCode.StateMachineNoChoiceMatched, "No choice matched, maybe it is a bug. Choice state name: " + choiceState.getName(), stateMachineInstance, null);
            EngineUtils.failStateMachine(context, (Exception)((Object)exception));
            throw exception;
        }
        context.setVariable("_current_choice_", (Object)choiceState.getDefault());
    }
}

