/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext;

import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.proctrl.Instruction;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.StateMachine;

public class StateInstruction
implements Instruction {
    private String stateName;
    private String stateMachineName;
    private String tenantId;
    private boolean end;
    private State temporaryState;

    public StateInstruction() {
    }

    public StateInstruction(String stateMachineName, String tenantId) {
        this.stateMachineName = stateMachineName;
        this.tenantId = tenantId;
    }

    public State getState(ProcessContext context) {
        State state;
        if (this.getTemporaryState() != null) {
            return this.temporaryState;
        }
        String stateName = this.getStateName();
        String stateMachineName = this.getStateMachineName();
        String tenantId = this.getTenantId();
        if (StringUtils.isEmpty((CharSequence)stateMachineName)) {
            throw new EngineExecutionException("StateMachineName is required", FrameworkErrorCode.ParameterRequired);
        }
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        StateMachine stateMachine = stateMachineConfig.getStateMachineRepository().getStateMachine(stateMachineName, tenantId);
        if (stateMachine == null) {
            throw new EngineExecutionException("StateMachine[" + stateMachineName + "] is not exist", FrameworkErrorCode.ObjectNotExists);
        }
        if (StringUtils.isEmpty((CharSequence)stateName)) {
            stateName = stateMachine.getStartState();
            this.setStateName(stateName);
        }
        if ((state = (State)stateMachine.getStates().get(stateName)) == null) {
            throw new EngineExecutionException("State[" + stateName + "] is not exist", FrameworkErrorCode.ObjectNotExists);
        }
        return state;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getStateMachineName() {
        return this.stateMachineName;
    }

    public void setStateMachineName(String stateMachineName) {
        this.stateMachineName = stateMachineName;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public State getTemporaryState() {
        return this.temporaryState;
    }

    public void setTemporaryState(State temporaryState) {
        this.temporaryState = temporaryState;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

