/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.expression.exception;

import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.expression.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMatchExpression
implements Expression {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionMatchExpression.class);
    private String expressionString;
    private Class<Exception> exceptionClass;

    @Override
    public Object getValue(Object elContext) {
        if (elContext instanceof Exception && StringUtils.hasText((CharSequence)this.expressionString)) {
            Exception e = (Exception)elContext;
            String exceptionClassName = e.getClass().getName();
            if (exceptionClassName.equals(this.expressionString)) {
                return true;
            }
            try {
                if (this.exceptionClass.isAssignableFrom(e.getClass())) {
                    return true;
                }
            }
            catch (Exception e1) {
                LOGGER.error("Exception Match failed. expression[{}]", (Object)this.expressionString, (Object)e1);
            }
        }
        return false;
    }

    @Override
    public void setValue(Object value, Object elContext) {
    }

    @Override
    public String getExpressionString() {
        return this.expressionString;
    }

    public void setExpressionString(String expressionString) {
        this.expressionString = expressionString;
        try {
            this.exceptionClass = Class.forName(expressionString);
        }
        catch (ClassNotFoundException e) {
            throw new EngineExecutionException(e, expressionString + " is not a Exception Class", FrameworkErrorCode.NotExceptionClass);
        }
    }
}

