/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.expression;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.expression.ExpressionFactory;

public class ExpressionFactoryManager {
    public static final String DEFAULT_EXPRESSION_TYPE = "Default";
    private final Map<String, ExpressionFactory> expressionFactoryMap = new ConcurrentHashMap<String, ExpressionFactory>();

    public ExpressionFactory getExpressionFactory(String expressionType) {
        if (StringUtils.isBlank((String)expressionType)) {
            expressionType = DEFAULT_EXPRESSION_TYPE;
        }
        return this.expressionFactoryMap.get(expressionType);
    }

    public void setExpressionFactoryMap(Map<String, ExpressionFactory> expressionFactoryMap) {
        this.expressionFactoryMap.putAll(expressionFactoryMap);
    }

    public void putExpressionFactory(String type, ExpressionFactory factory) {
        this.expressionFactoryMap.put(type, factory);
    }
}

