/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.rocketmq;

import java.util.Arrays;
import java.util.List;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.integration.rocketmq.SeataMQProducerFactory;
import org.apache.seata.integration.rocketmq.TCCRocketMQ;
import org.apache.seata.rm.DefaultResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeataMQProducer
extends TransactionMQProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataMQProducer.class);
    private static final List<GlobalStatus> COMMIT_STATUSES = Arrays.asList(GlobalStatus.Committed, GlobalStatus.Committing, GlobalStatus.CommitRetrying);
    private static final List<GlobalStatus> ROLLBACK_STATUSES = Arrays.asList(GlobalStatus.Rollbacked, GlobalStatus.Rollbacking, GlobalStatus.RollbackRetrying);
    public static String PROPERTY_SEATA_XID = "TX_XID";
    public static String PROPERTY_SEATA_BRANCHID = "TX_BRANCHID";
    private TransactionListener transactionListener = new TransactionListener(){

        public LocalTransactionState executeLocalTransaction(Message msg, Object arg) {
            return LocalTransactionState.UNKNOW;
        }

        public LocalTransactionState checkLocalTransaction(MessageExt msg) {
            String xid = msg.getProperty(PROPERTY_SEATA_XID);
            if (StringUtils.isBlank((String)xid)) {
                LOGGER.error("msg has no xid, msgTransactionId: {}, msg will be rollback", (Object)msg.getTransactionId());
                return LocalTransactionState.ROLLBACK_MESSAGE;
            }
            GlobalStatus globalStatus = DefaultResourceManager.get().getGlobalStatus(SeataMQProducerFactory.ROCKET_BRANCH_TYPE, xid);
            if (COMMIT_STATUSES.contains(globalStatus)) {
                return LocalTransactionState.COMMIT_MESSAGE;
            }
            if (ROLLBACK_STATUSES.contains(globalStatus) || GlobalStatus.isOnePhaseTimeout((GlobalStatus)globalStatus)) {
                return LocalTransactionState.ROLLBACK_MESSAGE;
            }
            if (GlobalStatus.Finished.equals((Object)globalStatus)) {
                LOGGER.error("global transaction finished, msg will be rollback, xid: {}", (Object)xid);
                return LocalTransactionState.ROLLBACK_MESSAGE;
            }
            return LocalTransactionState.UNKNOW;
        }
    };
    private TCCRocketMQ tccRocketMQ;

    SeataMQProducer(String producerGroup) {
        this(null, producerGroup, null);
    }

    SeataMQProducer(String namespace, String producerGroup, RPCHook rpcHook) {
        super(namespace, producerGroup, rpcHook);
    }

    public SendResult send(Message msg) throws MQClientException, MQBrokerException, RemotingException, InterruptedException {
        return this.send(msg, this.getSendMsgTimeout());
    }

    public SendResult send(Message msg, long timeout) throws MQClientException, MQBrokerException, RemotingException, InterruptedException {
        if (RootContext.inGlobalTransaction()) {
            if (this.tccRocketMQ == null) {
                throw new RuntimeException("TCCRocketMQ is not initialized");
            }
            return this.tccRocketMQ.prepare(msg, timeout);
        }
        return super.send(msg, timeout);
    }

    public SendResult doSendMessageInTransaction(Message msg, long timeout, String xid, long branchId) throws MQClientException {
        String transactionId;
        msg.setTopic(this.withNamespace(msg.getTopic()));
        if (msg.getDelayTimeLevel() != 0) {
            MessageAccessor.clearProperty((Message)msg, (String)"DELAY");
        }
        Validators.checkMessage((Message)msg, (DefaultMQProducer)this);
        SendResult sendResult = null;
        MessageAccessor.putProperty((Message)msg, (String)"TRAN_MSG", (String)"true");
        MessageAccessor.putProperty((Message)msg, (String)"PGROUP", (String)this.getProducerGroup());
        MessageAccessor.putProperty((Message)msg, (String)PROPERTY_SEATA_XID, (String)xid);
        MessageAccessor.putProperty((Message)msg, (String)PROPERTY_SEATA_BRANCHID, (String)String.valueOf(branchId));
        try {
            sendResult = super.send(msg, timeout);
        }
        catch (Exception e) {
            throw new MQClientException("send message Exception", (Throwable)e);
        }
        if (SendStatus.SEND_OK != sendResult.getSendStatus()) {
            throw new RuntimeException("Message send fail.status=" + sendResult.getSendStatus());
        }
        if (sendResult.getTransactionId() != null) {
            msg.putUserProperty("__transactionId__", sendResult.getTransactionId());
        }
        if (null != (transactionId = msg.getProperty("UNIQ_KEY")) && !"".equals(transactionId)) {
            msg.setTransactionId(transactionId);
        }
        return sendResult;
    }

    public TransactionListener getTransactionListener() {
        return this.transactionListener;
    }

    public void setTccRocketMQ(TCCRocketMQ tccRocketMQ) {
        this.tccRocketMQ = tccRocketMQ;
    }
}

