/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mockserver.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.apache.seata.core.protocol.RegisterRMRequest;
import org.apache.seata.core.protocol.RegisterRMResponse;
import org.apache.seata.core.protocol.RegisterTMRequest;
import org.apache.seata.core.protocol.RegisterTMResponse;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.protocol.Version;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.netty.ChannelManager;
import org.apache.seata.core.rpc.processor.RemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRegisterProcessor
implements RemotingProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MockRegisterProcessor.class);
    private final RemotingServer remotingServer;
    private final Role role;

    public MockRegisterProcessor(RemotingServer remotingServer, Role role) {
        this.remotingServer = remotingServer;
        this.role = role;
    }

    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        if (this.role == Role.TM) {
            RegisterTMRequest message = (RegisterTMRequest)rpcMessage.getBody();
            LOGGER.info("message = " + message);
            ChannelManager.registerTMChannel((RegisterTMRequest)message, (Channel)ctx.channel());
            Version.putChannelVersion((Channel)ctx.channel(), (String)message.getVersion());
            RegisterTMResponse resp = new RegisterTMResponse();
            this.remotingServer.sendAsyncResponse(rpcMessage, ctx.channel(), (Object)resp);
            LOGGER.info("sendAsyncResponse: {}", (Object)resp);
        } else if (this.role == Role.RM) {
            RegisterRMRequest message = (RegisterRMRequest)rpcMessage.getBody();
            LOGGER.info("message = " + message);
            ChannelManager.registerRMChannel((RegisterRMRequest)message, (Channel)ctx.channel());
            Version.putChannelVersion((Channel)ctx.channel(), (String)message.getVersion());
            RegisterRMResponse resp = new RegisterRMResponse();
            this.remotingServer.sendAsyncResponse(rpcMessage, ctx.channel(), (Object)resp);
            LOGGER.info("sendAsyncResponse: {}", (Object)resp);
        }
    }

    public static enum Role {
        TM,
        RM;

    }
}

